<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named executeSQLQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExecuteSQLQueryReq $axlParams
     * @return \StructType\ExecuteSQLQueryRes|bool
     */
    public function executeSQLQuery(\StructType\ExecuteSQLQueryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->executeSQLQuery($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named executeSQLUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExecuteSQLUpdateReq $axlParams
     * @return \StructType\ExecuteSQLUpdateRes|bool
     */
    public function executeSQLUpdate(\StructType\ExecuteSQLUpdateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->executeSQLUpdate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExecuteSQLQueryRes|\StructType\ExecuteSQLUpdateRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
