<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assign ServiceType
 * @subpackage Services
 */
class Assign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named assignPresenceUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssignPresenceUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function assignPresenceUser(\StructType\AssignPresenceUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->assignPresenceUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
