<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XSIPIdentityBlend EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XSIPIdentityBlend extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Deliver DN only in connected party'
     * @return string 'Deliver DN only in connected party'
     */
    const VALUE_DELIVER_DN_ONLY_IN_CONNECTED_PARTY = 'Deliver DN only in connected party';
    /**
     * Constant for value 'Deliver URI only in connected party, if available'
     * @return string 'Deliver URI only in connected party, if available'
     */
    const VALUE_DELIVER_URI_ONLY_IN_CONNECTED_PARTY_IF_AVAILABLE = 'Deliver URI only in connected party, if available';
    /**
     * Constant for value 'Deliver URI and DN in connected party, if available'
     * @return string 'Deliver URI and DN in connected party, if available'
     */
    const VALUE_DELIVER_URI_AND_DN_IN_CONNECTED_PARTY_IF_AVAILABLE = 'Deliver URI and DN in connected party, if available';
    /**
     * Return allowed values
     * @uses self::VALUE_DELIVER_DN_ONLY_IN_CONNECTED_PARTY
     * @uses self::VALUE_DELIVER_URI_ONLY_IN_CONNECTED_PARTY_IF_AVAILABLE
     * @uses self::VALUE_DELIVER_URI_AND_DN_IN_CONNECTED_PARTY_IF_AVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELIVER_DN_ONLY_IN_CONNECTED_PARTY,
            self::VALUE_DELIVER_URI_ONLY_IN_CONNECTED_PARTY_IF_AVAILABLE,
            self::VALUE_DELIVER_URI_AND_DN_IN_CONNECTED_PARTY_IF_AVAILABLE,
        );
    }
}
