<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XRingSetting EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XRingSetting extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'Disable'
     * @return string 'Disable'
     */
    const VALUE_DISABLE = 'Disable';
    /**
     * Constant for value 'Flash Only'
     * @return string 'Flash Only'
     */
    const VALUE_FLASH_ONLY = 'Flash Only';
    /**
     * Constant for value 'Ring Once'
     * @return string 'Ring Once'
     */
    const VALUE_RING_ONCE = 'Ring Once';
    /**
     * Constant for value 'Ring'
     * @return string 'Ring'
     */
    const VALUE_RING = 'Ring';
    /**
     * Constant for value 'Beep Only'
     * @return string 'Beep Only'
     */
    const VALUE_BEEP_ONLY = 'Beep Only';
    /**
     * Return allowed values
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_DISABLE
     * @uses self::VALUE_FLASH_ONLY
     * @uses self::VALUE_RING_ONCE
     * @uses self::VALUE_RING
     * @uses self::VALUE_BEEP_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_DISABLE,
            self::VALUE_FLASH_ONLY,
            self::VALUE_RING_ONCE,
            self::VALUE_RING,
            self::VALUE_BEEP_ONLY,
        );
    }
}
