<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XPRIChanIE EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XPRIChanIE extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Timeslot Number'
     * @return string 'Timeslot Number'
     */
    const VALUE_TIMESLOT_NUMBER = 'Timeslot Number';
    /**
     * Constant for value 'Slotmap'
     * @return string 'Slotmap'
     */
    const VALUE_SLOTMAP = 'Slotmap';
    /**
     * Constant for value 'Use Number when 1B'
     * @return string 'Use Number when 1B'
     */
    const VALUE_USE_NUMBER_WHEN_1_B = 'Use Number when 1B';
    /**
     * Constant for value 'Continuous Number'
     * @return string 'Continuous Number'
     */
    const VALUE_CONTINUOUS_NUMBER = 'Continuous Number';
    /**
     * Return allowed values
     * @uses self::VALUE_TIMESLOT_NUMBER
     * @uses self::VALUE_SLOTMAP
     * @uses self::VALUE_USE_NUMBER_WHEN_1_B
     * @uses self::VALUE_CONTINUOUS_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TIMESLOT_NUMBER,
            self::VALUE_SLOTMAP,
            self::VALUE_USE_NUMBER_WHEN_1_B,
            self::VALUE_CONTINUOUS_NUMBER,
        );
    }
}
