<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XMWLPolicy EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XMWLPolicy extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Use System Policy'
     * @return string 'Use System Policy'
     */
    const VALUE_USE_SYSTEM_POLICY = 'Use System Policy';
    /**
     * Constant for value 'Light and Prompt'
     * @return string 'Light and Prompt'
     */
    const VALUE_LIGHT_AND_PROMPT = 'Light and Prompt';
    /**
     * Constant for value 'Prompt Only'
     * @return string 'Prompt Only'
     */
    const VALUE_PROMPT_ONLY = 'Prompt Only';
    /**
     * Constant for value 'Light Only'
     * @return string 'Light Only'
     */
    const VALUE_LIGHT_ONLY = 'Light Only';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return allowed values
     * @uses self::VALUE_USE_SYSTEM_POLICY
     * @uses self::VALUE_LIGHT_AND_PROMPT
     * @uses self::VALUE_PROMPT_ONLY
     * @uses self::VALUE_LIGHT_ONLY
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_SYSTEM_POLICY,
            self::VALUE_LIGHT_AND_PROMPT,
            self::VALUE_PROMPT_ONLY,
            self::VALUE_LIGHT_ONLY,
            self::VALUE_NONE,
        );
    }
}
