<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVpnProfile StructType
 * @subpackage Structs
 */
class XVpnProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The autoNetworkDetection
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoNetworkDetection;
    /**
     * The mtu
     * Meta information extracted from the WSDL
     * - default: 1290
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mtu;
    /**
     * The failToConnect
     * Meta information extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $failToConnect;
    /**
     * The clientAuthentication
     * Meta information extracted from the WSDL
     * - default: User and Password
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clientAuthentication;
    /**
     * The pwdPersistant
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdPersistant;
    /**
     * The enableHostIdCheck
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableHostIdCheck;
    /**
     * Constructor method for XVpnProfile
     * @uses XVpnProfile::setName()
     * @uses XVpnProfile::setDescription()
     * @uses XVpnProfile::setAutoNetworkDetection()
     * @uses XVpnProfile::setMtu()
     * @uses XVpnProfile::setFailToConnect()
     * @uses XVpnProfile::setClientAuthentication()
     * @uses XVpnProfile::setPwdPersistant()
     * @uses XVpnProfile::setEnableHostIdCheck()
     * @param string $name
     * @param string $description
     * @param string $autoNetworkDetection
     * @param string $mtu
     * @param string $failToConnect
     * @param string $clientAuthentication
     * @param string $pwdPersistant
     * @param string $enableHostIdCheck
     */
    public function __construct($name = null, $description = null, $autoNetworkDetection = null, $mtu = '1290', $failToConnect = '30', $clientAuthentication = 'User and Password', $pwdPersistant = null, $enableHostIdCheck = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAutoNetworkDetection($autoNetworkDetection)
            ->setMtu($mtu)
            ->setFailToConnect($failToConnect)
            ->setClientAuthentication($clientAuthentication)
            ->setPwdPersistant($pwdPersistant)
            ->setEnableHostIdCheck($enableHostIdCheck);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XVpnProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XVpnProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoNetworkDetection value
     * @return string|null
     */
    public function getAutoNetworkDetection()
    {
        return $this->autoNetworkDetection;
    }
    /**
     * Set autoNetworkDetection value
     * @param string $autoNetworkDetection
     * @return \StructType\XVpnProfile
     */
    public function setAutoNetworkDetection($autoNetworkDetection = null)
    {
        // validation for constraint: string
        if (!is_null($autoNetworkDetection) && !is_string($autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoNetworkDetection, true), gettype($autoNetworkDetection)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($autoNetworkDetection) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($autoNetworkDetection, true)), __LINE__);
        }
        $this->autoNetworkDetection = $autoNetworkDetection;
        return $this;
    }
    /**
     * Get mtu value
     * @return string|null
     */
    public function getMtu()
    {
        return $this->mtu;
    }
    /**
     * Set mtu value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtu
     * @return \StructType\XVpnProfile
     */
    public function setMtu($mtu = '1290')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($mtu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($mtu) ? implode(', ', $mtu) : var_export($mtu, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mtu = $mtu;
        return $this;
    }
    /**
     * Get failToConnect value
     * @return string|null
     */
    public function getFailToConnect()
    {
        return $this->failToConnect;
    }
    /**
     * Set failToConnect value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failToConnect
     * @return \StructType\XVpnProfile
     */
    public function setFailToConnect($failToConnect = '30')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($failToConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($failToConnect) ? implode(', ', $failToConnect) : var_export($failToConnect, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->failToConnect = $failToConnect;
        return $this;
    }
    /**
     * Get clientAuthentication value
     * @return string|null
     */
    public function getClientAuthentication()
    {
        return $this->clientAuthentication;
    }
    /**
     * Set clientAuthentication value
     * @uses \EnumType\XVPNClientAuthentication::valueIsValid()
     * @uses \EnumType\XVPNClientAuthentication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientAuthentication
     * @return \StructType\XVpnProfile
     */
    public function setClientAuthentication($clientAuthentication = 'User and Password')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVPNClientAuthentication::valueIsValid($clientAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XVPNClientAuthentication', is_array($clientAuthentication) ? implode(', ', $clientAuthentication) : var_export($clientAuthentication, true), implode(', ', \EnumType\XVPNClientAuthentication::getValidValues())), __LINE__);
        }
        $this->clientAuthentication = $clientAuthentication;
        return $this;
    }
    /**
     * Get pwdPersistant value
     * @return string|null
     */
    public function getPwdPersistant()
    {
        return $this->pwdPersistant;
    }
    /**
     * Set pwdPersistant value
     * @param string $pwdPersistant
     * @return \StructType\XVpnProfile
     */
    public function setPwdPersistant($pwdPersistant = null)
    {
        // validation for constraint: string
        if (!is_null($pwdPersistant) && !is_string($pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdPersistant, true), gettype($pwdPersistant)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdPersistant) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdPersistant, true)), __LINE__);
        }
        $this->pwdPersistant = $pwdPersistant;
        return $this;
    }
    /**
     * Get enableHostIdCheck value
     * @return string|null
     */
    public function getEnableHostIdCheck()
    {
        return $this->enableHostIdCheck;
    }
    /**
     * Set enableHostIdCheck value
     * @param string $enableHostIdCheck
     * @return \StructType\XVpnProfile
     */
    public function setEnableHostIdCheck($enableHostIdCheck = null)
    {
        // validation for constraint: string
        if (!is_null($enableHostIdCheck) && !is_string($enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableHostIdCheck, true), gettype($enableHostIdCheck)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableHostIdCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableHostIdCheck, true)), __LINE__);
        }
        $this->enableHostIdCheck = $enableHostIdCheck;
        return $this;
    }
}
