<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVpnGroup StructType
 * @subpackage Structs
 */
class XVpnGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The vpnGateways
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VpnGateways
     */
    public $vpnGateways;
    /**
     * Constructor method for XVpnGroup
     * @uses XVpnGroup::setName()
     * @uses XVpnGroup::setDescription()
     * @uses XVpnGroup::setVpnGateways()
     * @param string $name
     * @param string $description
     * @param \StructType\VpnGateways $vpnGateways
     */
    public function __construct($name = null, $description = null, \StructType\VpnGateways $vpnGateways = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setVpnGateways($vpnGateways);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XVpnGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XVpnGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnGateways value
     * @return \StructType\VpnGateways|null
     */
    public function getVpnGateways()
    {
        return $this->vpnGateways;
    }
    /**
     * Set vpnGateways value
     * @param \StructType\VpnGateways $vpnGateways
     * @return \StructType\XVpnGroup
     */
    public function setVpnGateways(\StructType\VpnGateways $vpnGateways = null)
    {
        $this->vpnGateways = $vpnGateways;
        return $this;
    }
}
