<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUcService StructType
 * @subpackage Structs
 */
class XUcService extends AbstractStructBase
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The hostnameorip
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostnameorip;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence) and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $port;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence),CTI and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $protocol;
    /**
     * The ucServiceXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XVendorConfig
     */
    public $ucServiceXml;
    /**
     * Constructor method for XUcService
     * @uses XUcService::setServiceType()
     * @uses XUcService::setProductType()
     * @uses XUcService::setName()
     * @uses XUcService::setHostnameorip()
     * @uses XUcService::setDescription()
     * @uses XUcService::setPort()
     * @uses XUcService::setProtocol()
     * @uses XUcService::setUcServiceXml()
     * @param string $serviceType
     * @param string $productType
     * @param string $name
     * @param string $hostnameorip
     * @param string $description
     * @param string $port
     * @param string $protocol
     * @param \StructType\XVendorConfig $ucServiceXml
     */
    public function __construct($serviceType = null, $productType = null, $name = null, $hostnameorip = null, $description = null, $port = null, $protocol = null, \StructType\XVendorConfig $ucServiceXml = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setProductType($productType)
            ->setName($name)
            ->setHostnameorip($hostnameorip)
            ->setDescription($description)
            ->setPort($port)
            ->setProtocol($protocol)
            ->setUcServiceXml($ucServiceXml);
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\XUCService::valueIsValid()
     * @uses \EnumType\XUCService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\XUcService
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUCService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XUCService', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \EnumType\XUCService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get productType value
     * @return string
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \EnumType\XUCProduct::valueIsValid()
     * @uses \EnumType\XUCProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\XUcService
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUCProduct::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XUCProduct', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\XUCProduct::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XUcService
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get hostnameorip value
     * @return string
     */
    public function getHostnameorip()
    {
        return $this->hostnameorip;
    }
    /**
     * Set hostnameorip value
     * @param string $hostnameorip
     * @return \StructType\XUcService
     */
    public function setHostnameorip($hostnameorip = null)
    {
        // validation for constraint: string
        if (!is_null($hostnameorip) && !is_string($hostnameorip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostnameorip, true), gettype($hostnameorip)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($hostnameorip) && mb_strlen($hostnameorip) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($hostnameorip)), __LINE__);
        }
        $this->hostnameorip = $hostnameorip;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XUcService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : null;
    }
    /**
     * Set port value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XUcService
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($port) || (is_array($port) && empty($port))) {
            unset($this->port);
        } else {
            $this->port = $port;
        }
        return $this;
    }
    /**
     * Get protocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtocol()
    {
        return isset($this->protocol) ? $this->protocol : null;
    }
    /**
     * Set protocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XConnectProtocol::valueIsValid()
     * @uses \EnumType\XConnectProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\XUcService
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XConnectProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XConnectProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \EnumType\XConnectProtocol::getValidValues())), __LINE__);
        }
        if (is_null($protocol) || (is_array($protocol) && empty($protocol))) {
            unset($this->protocol);
        } else {
            $this->protocol = $protocol;
        }
        return $this;
    }
    /**
     * Get ucServiceXml value
     * @return \StructType\XVendorConfig|null
     */
    public function getUcServiceXml()
    {
        return $this->ucServiceXml;
    }
    /**
     * Set ucServiceXml value
     * @param \StructType\XVendorConfig $ucServiceXml
     * @return \StructType\XUcService
     */
    public function setUcServiceXml(\StructType\XVendorConfig $ucServiceXml = null)
    {
        $this->ucServiceXml = $ucServiceXml;
        return $this;
    }
}
