<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSubscribedService StructType
 * @subpackage Structs
 */
class XSubscribedService extends AbstractStructBase
{
    /**
     * The telecasterServiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $telecasterServiceName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $url;
    /**
     * The urlButtonIndex
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlButtonIndex;
    /**
     * The urlLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlLabel;
    /**
     * The serviceNameAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceNameAscii;
    /**
     * Constructor method for XSubscribedService
     * @uses XSubscribedService::setTelecasterServiceName()
     * @uses XSubscribedService::setName()
     * @uses XSubscribedService::setUrl()
     * @uses XSubscribedService::setUrlButtonIndex()
     * @uses XSubscribedService::setUrlLabel()
     * @uses XSubscribedService::setServiceNameAscii()
     * @param \StructType\XFkType $telecasterServiceName
     * @param string $name
     * @param string $url
     * @param string $urlButtonIndex
     * @param string $urlLabel
     * @param string $serviceNameAscii
     */
    public function __construct(\StructType\XFkType $telecasterServiceName = null, $name = null, $url = null, $urlButtonIndex = '0', $urlLabel = null, $serviceNameAscii = null)
    {
        $this
            ->setTelecasterServiceName($telecasterServiceName)
            ->setName($name)
            ->setUrl($url)
            ->setUrlButtonIndex($urlButtonIndex)
            ->setUrlLabel($urlLabel)
            ->setServiceNameAscii($serviceNameAscii);
    }
    /**
     * Get telecasterServiceName value
     * @return \StructType\XFkType
     */
    public function getTelecasterServiceName()
    {
        return $this->telecasterServiceName;
    }
    /**
     * Set telecasterServiceName value
     * @param \StructType\XFkType $telecasterServiceName
     * @return \StructType\XSubscribedService
     */
    public function setTelecasterServiceName(\StructType\XFkType $telecasterServiceName = null)
    {
        $this->telecasterServiceName = $telecasterServiceName;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XSubscribedService
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name) && mb_strlen($name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->url) ? $this->url : null;
    }
    /**
     * Set url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\XSubscribedService
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->url);
        } else {
            $this->url = $url;
        }
        return $this;
    }
    /**
     * Get urlButtonIndex value
     * @return string|null
     */
    public function getUrlButtonIndex()
    {
        return $this->urlButtonIndex;
    }
    /**
     * Set urlButtonIndex value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlButtonIndex
     * @return \StructType\XSubscribedService
     */
    public function setUrlButtonIndex($urlButtonIndex = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($urlButtonIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($urlButtonIndex) ? implode(', ', $urlButtonIndex) : var_export($urlButtonIndex, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->urlButtonIndex = $urlButtonIndex;
        return $this;
    }
    /**
     * Get urlLabel value
     * @return string|null
     */
    public function getUrlLabel()
    {
        return $this->urlLabel;
    }
    /**
     * Set urlLabel value
     * @param string $urlLabel
     * @return \StructType\XSubscribedService
     */
    public function setUrlLabel($urlLabel = null)
    {
        // validation for constraint: string
        if (!is_null($urlLabel) && !is_string($urlLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlLabel, true), gettype($urlLabel)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($urlLabel) && mb_strlen($urlLabel) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($urlLabel)), __LINE__);
        }
        $this->urlLabel = $urlLabel;
        return $this;
    }
    /**
     * Get serviceNameAscii value
     * @return string|null
     */
    public function getServiceNameAscii()
    {
        return $this->serviceNameAscii;
    }
    /**
     * Set serviceNameAscii value
     * @param string $serviceNameAscii
     * @return \StructType\XSubscribedService
     */
    public function setServiceNameAscii($serviceNameAscii = null)
    {
        // validation for constraint: string
        if (!is_null($serviceNameAscii) && !is_string($serviceNameAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceNameAscii, true), gettype($serviceNameAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($serviceNameAscii) && mb_strlen($serviceNameAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($serviceNameAscii)), __LINE__);
        }
        $this->serviceNameAscii = $serviceNameAscii;
        return $this;
    }
}
