<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipTrunkSecurityProfile StructType
 * @subpackage Structs
 */
class XSipTrunkSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The sipV150OutboundSdpOfferFiltering
     * Meta information extracted from the WSDL
     * - default: Use Default Filter
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $sipV150OutboundSdpOfferFiltering;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The incomingTransport
     * Meta information extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $incomingTransport;
    /**
     * The outgoingTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $outgoingTransport;
    /**
     * The digestAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $digestAuthentication;
    /**
     * The noncePolicyTime
     * Meta information extracted from the WSDL
     * - documentation: Only if digestAuthentication is enabled this value can be changed.
     * - default: 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $noncePolicyTime;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4096
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $x509SubjectName;
    /**
     * The incomingPort
     * Meta information extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $incomingPort;
    /**
     * The applLevelAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applLevelAuthentication;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The transmitSecurityStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitSecurityStatus;
    /**
     * The allowChargingHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowChargingHeader;
    /**
     * Constructor method for XSipTrunkSecurityProfile
     * @uses XSipTrunkSecurityProfile::setName()
     * @uses XSipTrunkSecurityProfile::setSipV150OutboundSdpOfferFiltering()
     * @uses XSipTrunkSecurityProfile::setDescription()
     * @uses XSipTrunkSecurityProfile::setSecurityMode()
     * @uses XSipTrunkSecurityProfile::setIncomingTransport()
     * @uses XSipTrunkSecurityProfile::setOutgoingTransport()
     * @uses XSipTrunkSecurityProfile::setDigestAuthentication()
     * @uses XSipTrunkSecurityProfile::setNoncePolicyTime()
     * @uses XSipTrunkSecurityProfile::setX509SubjectName()
     * @uses XSipTrunkSecurityProfile::setIncomingPort()
     * @uses XSipTrunkSecurityProfile::setApplLevelAuthentication()
     * @uses XSipTrunkSecurityProfile::setAcceptPresenceSubscription()
     * @uses XSipTrunkSecurityProfile::setAcceptOutOfDialogRefer()
     * @uses XSipTrunkSecurityProfile::setAcceptUnsolicitedNotification()
     * @uses XSipTrunkSecurityProfile::setAllowReplaceHeader()
     * @uses XSipTrunkSecurityProfile::setTransmitSecurityStatus()
     * @uses XSipTrunkSecurityProfile::setAllowChargingHeader()
     * @param string $name
     * @param string $sipV150OutboundSdpOfferFiltering
     * @param string $description
     * @param string $securityMode
     * @param string $incomingTransport
     * @param string $outgoingTransport
     * @param string $digestAuthentication
     * @param string $noncePolicyTime
     * @param string $x509SubjectName
     * @param string $incomingPort
     * @param string $applLevelAuthentication
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $transmitSecurityStatus
     * @param string $allowChargingHeader
     */
    public function __construct($name = null, $sipV150OutboundSdpOfferFiltering = 'Use Default Filter', $description = null, $securityMode = null, $incomingTransport = 'TCP+UDP', $outgoingTransport = null, $digestAuthentication = 'false', $noncePolicyTime = '600', $x509SubjectName = null, $incomingPort = '5060', $applLevelAuthentication = 'false', $acceptPresenceSubscription = 'false', $acceptOutOfDialogRefer = 'false', $acceptUnsolicitedNotification = 'false', $allowReplaceHeader = 'false', $transmitSecurityStatus = 'false', $allowChargingHeader = 'false')
    {
        $this
            ->setName($name)
            ->setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setIncomingTransport($incomingTransport)
            ->setOutgoingTransport($outgoingTransport)
            ->setDigestAuthentication($digestAuthentication)
            ->setNoncePolicyTime($noncePolicyTime)
            ->setX509SubjectName($x509SubjectName)
            ->setIncomingPort($incomingPort)
            ->setApplLevelAuthentication($applLevelAuthentication)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setTransmitSecurityStatus($transmitSecurityStatus)
            ->setAllowChargingHeader($allowChargingHeader);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sipV150OutboundSdpOfferFiltering value
     * @return string
     */
    public function getSipV150OutboundSdpOfferFiltering()
    {
        return $this->sipV150OutboundSdpOfferFiltering;
    }
    /**
     * Set sipV150OutboundSdpOfferFiltering value
     * @uses \EnumType\XV150SDPFilter::valueIsValid()
     * @uses \EnumType\XV150SDPFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipV150OutboundSdpOfferFiltering
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering = 'Use Default Filter')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XV150SDPFilter::valueIsValid($sipV150OutboundSdpOfferFiltering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XV150SDPFilter', is_array($sipV150OutboundSdpOfferFiltering) ? implode(', ', $sipV150OutboundSdpOfferFiltering) : var_export($sipV150OutboundSdpOfferFiltering, true), implode(', ', \EnumType\XV150SDPFilter::getValidValues())), __LINE__);
        }
        $this->sipV150OutboundSdpOfferFiltering = $sipV150OutboundSdpOfferFiltering;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($description) && mb_strlen($description) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get securityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityMode()
    {
        return isset($this->securityMode) ? $this->securityMode : null;
    }
    /**
     * Set securityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceSecurityMode', is_array($securityMode) ? implode(', ', $securityMode) : var_export($securityMode, true), implode(', ', \EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($securityMode) || (is_array($securityMode) && empty($securityMode))) {
            unset($this->securityMode);
        } else {
            $this->securityMode = $securityMode;
        }
        return $this;
    }
    /**
     * Get incomingTransport value
     * @return string|null
     */
    public function getIncomingTransport()
    {
        return $this->incomingTransport;
    }
    /**
     * Set incomingTransport value
     * @uses \EnumType\XTransport::valueIsValid()
     * @uses \EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingTransport
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setIncomingTransport($incomingTransport = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTransport::valueIsValid($incomingTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTransport', is_array($incomingTransport) ? implode(', ', $incomingTransport) : var_export($incomingTransport, true), implode(', ', \EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->incomingTransport = $incomingTransport;
        return $this;
    }
    /**
     * Get outgoingTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutgoingTransport()
    {
        return isset($this->outgoingTransport) ? $this->outgoingTransport : null;
    }
    /**
     * Set outgoingTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XTransport::valueIsValid()
     * @uses \EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outgoingTransport
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setOutgoingTransport($outgoingTransport = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTransport::valueIsValid($outgoingTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTransport', is_array($outgoingTransport) ? implode(', ', $outgoingTransport) : var_export($outgoingTransport, true), implode(', ', \EnumType\XTransport::getValidValues())), __LINE__);
        }
        if (is_null($outgoingTransport) || (is_array($outgoingTransport) && empty($outgoingTransport))) {
            unset($this->outgoingTransport);
        } else {
            $this->outgoingTransport = $outgoingTransport;
        }
        return $this;
    }
    /**
     * Get digestAuthentication value
     * @return string|null
     */
    public function getDigestAuthentication()
    {
        return $this->digestAuthentication;
    }
    /**
     * Set digestAuthentication value
     * @param string $digestAuthentication
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setDigestAuthentication($digestAuthentication = 'false')
    {
        // validation for constraint: string
        if (!is_null($digestAuthentication) && !is_string($digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestAuthentication, true), gettype($digestAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($digestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($digestAuthentication, true)), __LINE__);
        }
        $this->digestAuthentication = $digestAuthentication;
        return $this;
    }
    /**
     * Get noncePolicyTime value
     * @return string|null
     */
    public function getNoncePolicyTime()
    {
        return $this->noncePolicyTime;
    }
    /**
     * Set noncePolicyTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $noncePolicyTime
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setNoncePolicyTime($noncePolicyTime = '600')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($noncePolicyTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($noncePolicyTime) ? implode(', ', $noncePolicyTime) : var_export($noncePolicyTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->noncePolicyTime = $noncePolicyTime;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SubjectName, true), gettype($x509SubjectName)), __LINE__);
        }
        // validation for constraint: maxLength(4096)
        if (!is_null($x509SubjectName) && mb_strlen($x509SubjectName) > 4096) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4096', mb_strlen($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get incomingPort value
     * @return string|null
     */
    public function getIncomingPort()
    {
        return $this->incomingPort;
    }
    /**
     * Set incomingPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingPort
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setIncomingPort($incomingPort = '5060')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($incomingPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($incomingPort) ? implode(', ', $incomingPort) : var_export($incomingPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->incomingPort = $incomingPort;
        return $this;
    }
    /**
     * Get applLevelAuthentication value
     * @return string|null
     */
    public function getApplLevelAuthentication()
    {
        return $this->applLevelAuthentication;
    }
    /**
     * Set applLevelAuthentication value
     * @param string $applLevelAuthentication
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setApplLevelAuthentication($applLevelAuthentication = 'false')
    {
        // validation for constraint: string
        if (!is_null($applLevelAuthentication) && !is_string($applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applLevelAuthentication, true), gettype($applLevelAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($applLevelAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($applLevelAuthentication, true)), __LINE__);
        }
        $this->applLevelAuthentication = $applLevelAuthentication;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = 'false')
    {
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptPresenceSubscription, true), gettype($acceptPresenceSubscription)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = 'false')
    {
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptOutOfDialogRefer, true), gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = 'false')
    {
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUnsolicitedNotification, true), gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setAllowReplaceHeader($allowReplaceHeader = 'false')
    {
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowReplaceHeader, true), gettype($allowReplaceHeader)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowReplaceHeader, true)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get transmitSecurityStatus value
     * @return string|null
     */
    public function getTransmitSecurityStatus()
    {
        return $this->transmitSecurityStatus;
    }
    /**
     * Set transmitSecurityStatus value
     * @param string $transmitSecurityStatus
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setTransmitSecurityStatus($transmitSecurityStatus = 'false')
    {
        // validation for constraint: string
        if (!is_null($transmitSecurityStatus) && !is_string($transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitSecurityStatus, true), gettype($transmitSecurityStatus)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($transmitSecurityStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($transmitSecurityStatus, true)), __LINE__);
        }
        $this->transmitSecurityStatus = $transmitSecurityStatus;
        return $this;
    }
    /**
     * Get allowChargingHeader value
     * @return string|null
     */
    public function getAllowChargingHeader()
    {
        return $this->allowChargingHeader;
    }
    /**
     * Set allowChargingHeader value
     * @param string $allowChargingHeader
     * @return \StructType\XSipTrunkSecurityProfile
     */
    public function setAllowChargingHeader($allowChargingHeader = 'false')
    {
        // validation for constraint: string
        if (!is_null($allowChargingHeader) && !is_string($allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowChargingHeader, true), gettype($allowChargingHeader)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowChargingHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowChargingHeader, true)), __LINE__);
        }
        $this->allowChargingHeader = $allowChargingHeader;
        return $this;
    }
}
