<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XServiceProfile StructType
 * @subpackage Structs
 */
class XServiceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The serviceProfileInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceProfileInfos
     */
    public $serviceProfileInfos;
    /**
     * Constructor method for XServiceProfile
     * @uses XServiceProfile::setName()
     * @uses XServiceProfile::setDescription()
     * @uses XServiceProfile::setIsDefault()
     * @uses XServiceProfile::setServiceProfileInfos()
     * @param string $name
     * @param string $description
     * @param string $isDefault
     * @param \StructType\ServiceProfileInfos $serviceProfileInfos
     */
    public function __construct($name = null, $description = null, $isDefault = null, \StructType\ServiceProfileInfos $serviceProfileInfos = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setServiceProfileInfos($serviceProfileInfos);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XServiceProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XServiceProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\XServiceProfile
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get serviceProfileInfos value
     * @return \StructType\ServiceProfileInfos|null
     */
    public function getServiceProfileInfos()
    {
        return $this->serviceProfileInfos;
    }
    /**
     * Set serviceProfileInfos value
     * @param \StructType\ServiceProfileInfos $serviceProfileInfos
     * @return \StructType\XServiceProfile
     */
    public function setServiceProfileInfos(\StructType\ServiceProfileInfos $serviceProfileInfos = null)
    {
        $this->serviceProfileInfos = $serviceProfileInfos;
        return $this;
    }
}
