<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRoutePlan StructType
 * @subpackage Structs
 */
class XRoutePlan extends AbstractStructBase
{
    /**
     * The dnOrPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $dnOrPattern;
    /**
     * The partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $partition;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $type;
    /**
     * The routeDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $routeDetail;
    /**
     * Constructor method for XRoutePlan
     * @uses XRoutePlan::setDnOrPattern()
     * @uses XRoutePlan::setPartition()
     * @uses XRoutePlan::setType()
     * @uses XRoutePlan::setRouteDetail()
     * @param string $dnOrPattern
     * @param \StructType\XFkType $partition
     * @param string $type
     * @param string $routeDetail
     */
    public function __construct($dnOrPattern = null, \StructType\XFkType $partition = null, $type = null, $routeDetail = null)
    {
        $this
            ->setDnOrPattern($dnOrPattern)
            ->setPartition($partition)
            ->setType($type)
            ->setRouteDetail($routeDetail);
    }
    /**
     * Get dnOrPattern value
     * @return string
     */
    public function getDnOrPattern()
    {
        return $this->dnOrPattern;
    }
    /**
     * Set dnOrPattern value
     * @param string $dnOrPattern
     * @return \StructType\XRoutePlan
     */
    public function setDnOrPattern($dnOrPattern = null)
    {
        // validation for constraint: string
        if (!is_null($dnOrPattern) && !is_string($dnOrPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnOrPattern, true), gettype($dnOrPattern)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dnOrPattern) && mb_strlen($dnOrPattern) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dnOrPattern)), __LINE__);
        }
        $this->dnOrPattern = $dnOrPattern;
        return $this;
    }
    /**
     * Get partition value
     * @return \StructType\XFkType
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \StructType\XFkType $partition
     * @return \StructType\XRoutePlan
     */
    public function setPartition(\StructType\XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\XPatternUsage::valueIsValid()
     * @uses \EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\XRoutePlan
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPatternUsage::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPatternUsage', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get routeDetail value
     * @return string
     */
    public function getRouteDetail()
    {
        return $this->routeDetail;
    }
    /**
     * Set routeDetail value
     * @param string $routeDetail
     * @return \StructType\XRoutePlan
     */
    public function setRouteDetail($routeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($routeDetail) && !is_string($routeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeDetail, true), gettype($routeDetail)), __LINE__);
        }
        $this->routeDetail = $routeDetail;
        return $this;
    }
}
