<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRecordingProfile StructType
 * @subpackage Structs
 */
class XRecordingProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The recorderDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $recorderDestination;
    /**
     * The recordingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $recordingCssName;
    /**
     * Constructor method for XRecordingProfile
     * @uses XRecordingProfile::setName()
     * @uses XRecordingProfile::setRecorderDestination()
     * @uses XRecordingProfile::setRecordingCssName()
     * @param string $name
     * @param string $recorderDestination
     * @param \StructType\XFkType $recordingCssName
     */
    public function __construct($name = null, $recorderDestination = null, \StructType\XFkType $recordingCssName = null)
    {
        $this
            ->setName($name)
            ->setRecorderDestination($recorderDestination)
            ->setRecordingCssName($recordingCssName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XRecordingProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get recorderDestination value
     * @return string
     */
    public function getRecorderDestination()
    {
        return $this->recorderDestination;
    }
    /**
     * Set recorderDestination value
     * @param string $recorderDestination
     * @return \StructType\XRecordingProfile
     */
    public function setRecorderDestination($recorderDestination = null)
    {
        // validation for constraint: string
        if (!is_null($recorderDestination) && !is_string($recorderDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recorderDestination, true), gettype($recorderDestination)), __LINE__);
        }
        $this->recorderDestination = $recorderDestination;
        return $this;
    }
    /**
     * Get recordingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRecordingCssName()
    {
        return isset($this->recordingCssName) ? $this->recordingCssName : null;
    }
    /**
     * Set recordingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $recordingCssName
     * @return \StructType\XRecordingProfile
     */
    public function setRecordingCssName(\StructType\XFkType $recordingCssName = null)
    {
        if (is_null($recordingCssName) || (is_array($recordingCssName) && empty($recordingCssName))) {
            unset($this->recordingCssName);
        } else {
            $this->recordingCssName = $recordingCssName;
        }
        return $this;
    }
}
