<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPatternMember StructType
 * @subpackage Structs
 */
class XPatternMember extends AbstractStructBase
{
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $selectionOrder;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The dialParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DialParameters
     */
    public $dialParameters;
    /**
     * Constructor method for XPatternMember
     * @uses XPatternMember::setSelectionOrder()
     * @uses XPatternMember::setDescription()
     * @uses XPatternMember::setDialParameters()
     * @param string $selectionOrder
     * @param string $description
     * @param \StructType\DialParameters $dialParameters
     */
    public function __construct($selectionOrder = null, $description = null, \StructType\DialParameters $dialParameters = null)
    {
        $this
            ->setSelectionOrder($selectionOrder)
            ->setDescription($description)
            ->setDialParameters($dialParameters);
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\XPatternMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\XPatternMember
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get dialParameters value
     * @return \StructType\DialParameters|null
     */
    public function getDialParameters()
    {
        return $this->dialParameters;
    }
    /**
     * Set dialParameters value
     * @param \StructType\DialParameters $dialParameters
     * @return \StructType\XPatternMember
     */
    public function setDialParameters(\StructType\DialParameters $dialParameters = null)
    {
        $this->dialParameters = $dialParameters;
        return $this;
    }
}
