<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XNumplanIdentifier StructType
 * @subpackage Structs
 */
class XNumplanIdentifier extends AbstractStructBase
{
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $directoryNumber;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $routePartitionName;
    /**
     * Constructor method for XNumplanIdentifier
     * @uses XNumplanIdentifier::setDirectoryNumber()
     * @uses XNumplanIdentifier::setRoutePartitionName()
     * @param string $directoryNumber
     * @param string $routePartitionName
     */
    public function __construct($directoryNumber = null, $routePartitionName = null)
    {
        $this
            ->setDirectoryNumber($directoryNumber)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get directoryNumber value
     * @return string
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \StructType\XNumplanIdentifier
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($directoryNumber) && !is_string($directoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryNumber, true), gettype($directoryNumber)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($directoryNumber) && mb_strlen($directoryNumber) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($directoryNumber)), __LINE__);
        }
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return string
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param string $routePartitionName
     * @return \StructType\XNumplanIdentifier
     */
    public function setRoutePartitionName($routePartitionName = null)
    {
        // validation for constraint: string
        if (!is_null($routePartitionName) && !is_string($routePartitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routePartitionName, true), gettype($routePartitionName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($routePartitionName) && mb_strlen($routePartitionName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($routePartitionName)), __LINE__);
        }
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
}
