<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLineGroupMember StructType
 * @subpackage Structs
 */
class XLineGroupMember extends AbstractStructBase
{
    /**
     * The lineSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lineSelectionOrder;
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - documentation: The uuid attribute is read here
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XDirn
     */
    public $directoryNumber;
    /**
     * Constructor method for XLineGroupMember
     * @uses XLineGroupMember::setLineSelectionOrder()
     * @uses XLineGroupMember::setDirectoryNumber()
     * @param string $lineSelectionOrder
     * @param \StructType\XDirn $directoryNumber
     */
    public function __construct($lineSelectionOrder = null, \StructType\XDirn $directoryNumber = null)
    {
        $this
            ->setLineSelectionOrder($lineSelectionOrder)
            ->setDirectoryNumber($directoryNumber);
    }
    /**
     * Get lineSelectionOrder value
     * @return string
     */
    public function getLineSelectionOrder()
    {
        return $this->lineSelectionOrder;
    }
    /**
     * Set lineSelectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineSelectionOrder
     * @return \StructType\XLineGroupMember
     */
    public function setLineSelectionOrder($lineSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($lineSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($lineSelectionOrder) ? implode(', ', $lineSelectionOrder) : var_export($lineSelectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->lineSelectionOrder = $lineSelectionOrder;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return \StructType\XDirn
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param \StructType\XDirn $directoryNumber
     * @return \StructType\XLineGroupMember
     */
    public function setDirectoryNumber(\StructType\XDirn $directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
}
