<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XIpPhoneServices StructType
 * @subpackage Structs
 */
class XIpPhoneServices extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceName;
    /**
     * The asciiServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $serviceUrl;
    /**
     * The serviceCategory
     * Meta information extracted from the WSDL
     * - default: XML Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - default: Standard IP Phone Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceDescription;
    /**
     * The secureServiceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The enterpriseSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enterpriseSubscription;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Parameters
     */
    public $parameters;
    /**
     * Constructor method for XIpPhoneServices
     * @uses XIpPhoneServices::setServiceName()
     * @uses XIpPhoneServices::setAsciiServiceName()
     * @uses XIpPhoneServices::setServiceUrl()
     * @uses XIpPhoneServices::setServiceCategory()
     * @uses XIpPhoneServices::setServiceType()
     * @uses XIpPhoneServices::setServiceDescription()
     * @uses XIpPhoneServices::setSecureServiceUrl()
     * @uses XIpPhoneServices::setServiceVendor()
     * @uses XIpPhoneServices::setServiceVersion()
     * @uses XIpPhoneServices::setEnabled()
     * @uses XIpPhoneServices::setEnterpriseSubscription()
     * @uses XIpPhoneServices::setParameters()
     * @param string $serviceName
     * @param string $asciiServiceName
     * @param string $serviceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceDescription
     * @param string $secureServiceUrl
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param string $enterpriseSubscription
     * @param \StructType\Parameters $parameters
     */
    public function __construct($serviceName = null, $asciiServiceName = null, $serviceUrl = null, $serviceCategory = 'XML Service', $serviceType = 'Standard IP Phone Service', $serviceDescription = null, $secureServiceUrl = null, $serviceVendor = null, $serviceVersion = null, $enabled = 'true', $enterpriseSubscription = 'false', \StructType\Parameters $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceUrl($serviceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceDescription($serviceDescription)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setEnterpriseSubscription($enterpriseSubscription)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($serviceName) && mb_strlen($serviceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \StructType\XIpPhoneServices
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($asciiServiceName) && !is_string($asciiServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiServiceName, true), gettype($asciiServiceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($asciiServiceName) && mb_strlen($asciiServiceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($asciiServiceName)), __LINE__);
        }
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceUrl value
     * @return string
     */
    public function getServiceUrl()
    {
        return $this->serviceUrl;
    }
    /**
     * Set serviceUrl value
     * @param string $serviceUrl
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceUrl($serviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceUrl, true), gettype($serviceUrl)), __LINE__);
        }
        $this->serviceUrl = $serviceUrl;
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses \EnumType\XPhoneServiceCategory::valueIsValid()
     * @uses \EnumType\XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCategory
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceCategory($serviceCategory = 'XML Service')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceCategory::valueIsValid($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPhoneServiceCategory', is_array($serviceCategory) ? implode(', ', $serviceCategory) : var_export($serviceCategory, true), implode(', ', \EnumType\XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\XPhoneService::valueIsValid()
     * @uses \EnumType\XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceType($serviceType = 'Standard IP Phone Service')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPhoneService', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \EnumType\XPhoneService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->serviceDescription) ? $this->serviceDescription : null;
    }
    /**
     * Set serviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDescription, true), gettype($serviceDescription)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($serviceDescription) && mb_strlen($serviceDescription) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($serviceDescription)), __LINE__);
        }
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->serviceDescription);
        } else {
            $this->serviceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return isset($this->secureServiceUrl) ? $this->secureServiceUrl : null;
    }
    /**
     * Set secureServiceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secureServiceUrl
     * @return \StructType\XIpPhoneServices
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServiceUrl) && !is_string($secureServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureServiceUrl, true), gettype($secureServiceUrl)), __LINE__);
        }
        if (is_null($secureServiceUrl) || (is_array($secureServiceUrl) && empty($secureServiceUrl))) {
            unset($this->secureServiceUrl);
        } else {
            $this->secureServiceUrl = $secureServiceUrl;
        }
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceVendor($serviceVendor = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVendor) && !is_string($serviceVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVendor, true), gettype($serviceVendor)), __LINE__);
        }
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \StructType\XIpPhoneServices
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVersion, true), gettype($serviceVersion)), __LINE__);
        }
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\XIpPhoneServices
     */
    public function setEnabled($enabled = 'true')
    {
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enabled, true)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get enterpriseSubscription value
     * @return string|null
     */
    public function getEnterpriseSubscription()
    {
        return $this->enterpriseSubscription;
    }
    /**
     * Set enterpriseSubscription value
     * @param string $enterpriseSubscription
     * @return \StructType\XIpPhoneServices
     */
    public function setEnterpriseSubscription($enterpriseSubscription = 'false')
    {
        // validation for constraint: string
        if (!is_null($enterpriseSubscription) && !is_string($enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enterpriseSubscription, true), gettype($enterpriseSubscription)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enterpriseSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enterpriseSubscription, true)), __LINE__);
        }
        $this->enterpriseSubscription = $enterpriseSubscription;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\Parameters $parameters
     * @return \StructType\XIpPhoneServices
     */
    public function setParameters(\StructType\Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
}
