<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeEnrolledPatternGroup StructType
 * @subpackage Structs
 */
class XImeEnrolledPatternGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The fallbackProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $fallbackProfileName;
    /**
     * The isPatternAllAlias
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPatternAllAlias;
    /**
     * Constructor method for XImeEnrolledPatternGroup
     * @uses XImeEnrolledPatternGroup::setName()
     * @uses XImeEnrolledPatternGroup::setDescription()
     * @uses XImeEnrolledPatternGroup::setFallbackProfileName()
     * @uses XImeEnrolledPatternGroup::setIsPatternAllAlias()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $fallbackProfileName
     * @param string $isPatternAllAlias
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $fallbackProfileName = null, $isPatternAllAlias = 'false')
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFallbackProfileName($fallbackProfileName)
            ->setIsPatternAllAlias($isPatternAllAlias);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XImeEnrolledPatternGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XImeEnrolledPatternGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fallbackProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getFallbackProfileName()
    {
        return isset($this->fallbackProfileName) ? $this->fallbackProfileName : null;
    }
    /**
     * Set fallbackProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $fallbackProfileName
     * @return \StructType\XImeEnrolledPatternGroup
     */
    public function setFallbackProfileName(\StructType\XFkType $fallbackProfileName = null)
    {
        if (is_null($fallbackProfileName) || (is_array($fallbackProfileName) && empty($fallbackProfileName))) {
            unset($this->fallbackProfileName);
        } else {
            $this->fallbackProfileName = $fallbackProfileName;
        }
        return $this;
    }
    /**
     * Get isPatternAllAlias value
     * @return string|null
     */
    public function getIsPatternAllAlias()
    {
        return $this->isPatternAllAlias;
    }
    /**
     * Set isPatternAllAlias value
     * @param string $isPatternAllAlias
     * @return \StructType\XImeEnrolledPatternGroup
     */
    public function setIsPatternAllAlias($isPatternAllAlias = 'false')
    {
        // validation for constraint: string
        if (!is_null($isPatternAllAlias) && !is_string($isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPatternAllAlias, true), gettype($isPatternAllAlias)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPatternAllAlias) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPatternAllAlias, true)), __LINE__);
        }
        $this->isPatternAllAlias = $isPatternAllAlias;
        return $this;
    }
}
