<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDirNumberAliasLookupandSync StructType
 * @subpackage Structs
 */
class XDirNumberAliasLookupandSync extends AbstractStructBase
{
    /**
     * The ldapConfigName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapConfigName;
    /**
     * The ldapManagerDisgName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapManagerDisgName;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapPassword;
    /**
     * The ldapUserSearch
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapUserSearch;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Servers
     */
    public $servers;
    /**
     * The ldapDirectoryServerUsage
     * Meta information extracted from the WSDL
     * - default: DirSync
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapDirectoryServerUsage;
    /**
     * The keepAliveSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $keepAliveSearch;
    /**
     * The keepAliveTime
     * Meta information extracted from the WSDL
     * - default: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keepAliveTime;
    /**
     * The sipAliasSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The enableCachingofRecords
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCachingofRecords;
    /**
     * The cacheSizeforAliasLookup
     * Meta information extracted from the WSDL
     * - default: 3000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cacheSizeforAliasLookup;
    /**
     * The cacheAgeforAliasLookup
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cacheAgeforAliasLookup;
    /**
     * Constructor method for XDirNumberAliasLookupandSync
     * @uses XDirNumberAliasLookupandSync::setLdapConfigName()
     * @uses XDirNumberAliasLookupandSync::setLdapManagerDisgName()
     * @uses XDirNumberAliasLookupandSync::setLdapPassword()
     * @uses XDirNumberAliasLookupandSync::setLdapUserSearch()
     * @uses XDirNumberAliasLookupandSync::setServers()
     * @uses XDirNumberAliasLookupandSync::setLdapDirectoryServerUsage()
     * @uses XDirNumberAliasLookupandSync::setKeepAliveSearch()
     * @uses XDirNumberAliasLookupandSync::setKeepAliveTime()
     * @uses XDirNumberAliasLookupandSync::setSipAliasSuffix()
     * @uses XDirNumberAliasLookupandSync::setEnableCachingofRecords()
     * @uses XDirNumberAliasLookupandSync::setCacheSizeforAliasLookup()
     * @uses XDirNumberAliasLookupandSync::setCacheAgeforAliasLookup()
     * @param string $ldapConfigName
     * @param string $ldapManagerDisgName
     * @param string $ldapPassword
     * @param string $ldapUserSearch
     * @param \StructType\Servers $servers
     * @param string $ldapDirectoryServerUsage
     * @param string $keepAliveSearch
     * @param string $keepAliveTime
     * @param string $sipAliasSuffix
     * @param string $enableCachingofRecords
     * @param string $cacheSizeforAliasLookup
     * @param string $cacheAgeforAliasLookup
     */
    public function __construct($ldapConfigName = null, $ldapManagerDisgName = null, $ldapPassword = null, $ldapUserSearch = null, \StructType\Servers $servers = null, $ldapDirectoryServerUsage = 'DirSync', $keepAliveSearch = null, $keepAliveTime = '5', $sipAliasSuffix = null, $enableCachingofRecords = null, $cacheSizeforAliasLookup = '3000', $cacheAgeforAliasLookup = '0')
    {
        $this
            ->setLdapConfigName($ldapConfigName)
            ->setLdapManagerDisgName($ldapManagerDisgName)
            ->setLdapPassword($ldapPassword)
            ->setLdapUserSearch($ldapUserSearch)
            ->setServers($servers)
            ->setLdapDirectoryServerUsage($ldapDirectoryServerUsage)
            ->setKeepAliveSearch($keepAliveSearch)
            ->setKeepAliveTime($keepAliveTime)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setEnableCachingofRecords($enableCachingofRecords)
            ->setCacheSizeforAliasLookup($cacheSizeforAliasLookup)
            ->setCacheAgeforAliasLookup($cacheAgeforAliasLookup);
    }
    /**
     * Get ldapConfigName value
     * @return string
     */
    public function getLdapConfigName()
    {
        return $this->ldapConfigName;
    }
    /**
     * Set ldapConfigName value
     * @param string $ldapConfigName
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setLdapConfigName($ldapConfigName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapConfigName) && !is_string($ldapConfigName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapConfigName, true), gettype($ldapConfigName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ldapConfigName) && mb_strlen($ldapConfigName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ldapConfigName)), __LINE__);
        }
        $this->ldapConfigName = $ldapConfigName;
        return $this;
    }
    /**
     * Get ldapManagerDisgName value
     * @return string
     */
    public function getLdapManagerDisgName()
    {
        return $this->ldapManagerDisgName;
    }
    /**
     * Set ldapManagerDisgName value
     * @param string $ldapManagerDisgName
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setLdapManagerDisgName($ldapManagerDisgName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapManagerDisgName) && !is_string($ldapManagerDisgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapManagerDisgName, true), gettype($ldapManagerDisgName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapManagerDisgName) && mb_strlen($ldapManagerDisgName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapManagerDisgName)), __LINE__);
        }
        $this->ldapManagerDisgName = $ldapManagerDisgName;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapPassword, true), gettype($ldapPassword)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapPassword) && mb_strlen($ldapPassword) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get ldapUserSearch value
     * @return string
     */
    public function getLdapUserSearch()
    {
        return $this->ldapUserSearch;
    }
    /**
     * Set ldapUserSearch value
     * @param string $ldapUserSearch
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setLdapUserSearch($ldapUserSearch = null)
    {
        // validation for constraint: string
        if (!is_null($ldapUserSearch) && !is_string($ldapUserSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapUserSearch, true), gettype($ldapUserSearch)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ldapUserSearch) && mb_strlen($ldapUserSearch) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ldapUserSearch)), __LINE__);
        }
        $this->ldapUserSearch = $ldapUserSearch;
        return $this;
    }
    /**
     * Get servers value
     * @return \StructType\Servers
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \StructType\Servers $servers
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setServers(\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get ldapDirectoryServerUsage value
     * @return string|null
     */
    public function getLdapDirectoryServerUsage()
    {
        return $this->ldapDirectoryServerUsage;
    }
    /**
     * Set ldapDirectoryServerUsage value
     * @uses \EnumType\XLDAPDirectoryFunction::valueIsValid()
     * @uses \EnumType\XLDAPDirectoryFunction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapDirectoryServerUsage
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setLdapDirectoryServerUsage($ldapDirectoryServerUsage = 'DirSync')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XLDAPDirectoryFunction::valueIsValid($ldapDirectoryServerUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XLDAPDirectoryFunction', is_array($ldapDirectoryServerUsage) ? implode(', ', $ldapDirectoryServerUsage) : var_export($ldapDirectoryServerUsage, true), implode(', ', \EnumType\XLDAPDirectoryFunction::getValidValues())), __LINE__);
        }
        $this->ldapDirectoryServerUsage = $ldapDirectoryServerUsage;
        return $this;
    }
    /**
     * Get keepAliveSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeepAliveSearch()
    {
        return isset($this->keepAliveSearch) ? $this->keepAliveSearch : null;
    }
    /**
     * Set keepAliveSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keepAliveSearch
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setKeepAliveSearch($keepAliveSearch = null)
    {
        // validation for constraint: string
        if (!is_null($keepAliveSearch) && !is_string($keepAliveSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keepAliveSearch, true), gettype($keepAliveSearch)), __LINE__);
        }
        if (is_null($keepAliveSearch) || (is_array($keepAliveSearch) && empty($keepAliveSearch))) {
            unset($this->keepAliveSearch);
        } else {
            $this->keepAliveSearch = $keepAliveSearch;
        }
        return $this;
    }
    /**
     * Get keepAliveTime value
     * @return string|null
     */
    public function getKeepAliveTime()
    {
        return $this->keepAliveTime;
    }
    /**
     * Set keepAliveTime value
     * @uses \EnumType\XKeepAliveTimeInterval::valueIsValid()
     * @uses \EnumType\XKeepAliveTimeInterval::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keepAliveTime
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setKeepAliveTime($keepAliveTime = '5')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeepAliveTimeInterval::valueIsValid($keepAliveTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XKeepAliveTimeInterval', is_array($keepAliveTime) ? implode(', ', $keepAliveTime) : var_export($keepAliveTime, true), implode(', ', \EnumType\XKeepAliveTimeInterval::getValidValues())), __LINE__);
        }
        $this->keepAliveTime = $keepAliveTime;
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return isset($this->sipAliasSuffix) ? $this->sipAliasSuffix : null;
    }
    /**
     * Set sipAliasSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sipAliasSuffix
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipAliasSuffix) && !is_string($sipAliasSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipAliasSuffix, true), gettype($sipAliasSuffix)), __LINE__);
        }
        if (is_null($sipAliasSuffix) || (is_array($sipAliasSuffix) && empty($sipAliasSuffix))) {
            unset($this->sipAliasSuffix);
        } else {
            $this->sipAliasSuffix = $sipAliasSuffix;
        }
        return $this;
    }
    /**
     * Get enableCachingofRecords value
     * @return string|null
     */
    public function getEnableCachingofRecords()
    {
        return $this->enableCachingofRecords;
    }
    /**
     * Set enableCachingofRecords value
     * @param string $enableCachingofRecords
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setEnableCachingofRecords($enableCachingofRecords = null)
    {
        // validation for constraint: string
        if (!is_null($enableCachingofRecords) && !is_string($enableCachingofRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableCachingofRecords, true), gettype($enableCachingofRecords)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableCachingofRecords) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCachingofRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableCachingofRecords, true)), __LINE__);
        }
        $this->enableCachingofRecords = $enableCachingofRecords;
        return $this;
    }
    /**
     * Get cacheSizeforAliasLookup value
     * @return string|null
     */
    public function getCacheSizeforAliasLookup()
    {
        return $this->cacheSizeforAliasLookup;
    }
    /**
     * Set cacheSizeforAliasLookup value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cacheSizeforAliasLookup
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setCacheSizeforAliasLookup($cacheSizeforAliasLookup = '3000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($cacheSizeforAliasLookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($cacheSizeforAliasLookup) ? implode(', ', $cacheSizeforAliasLookup) : var_export($cacheSizeforAliasLookup, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->cacheSizeforAliasLookup = $cacheSizeforAliasLookup;
        return $this;
    }
    /**
     * Get cacheAgeforAliasLookup value
     * @return string|null
     */
    public function getCacheAgeforAliasLookup()
    {
        return $this->cacheAgeforAliasLookup;
    }
    /**
     * Set cacheAgeforAliasLookup value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cacheAgeforAliasLookup
     * @return \StructType\XDirNumberAliasLookupandSync
     */
    public function setCacheAgeforAliasLookup($cacheAgeforAliasLookup = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($cacheAgeforAliasLookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($cacheAgeforAliasLookup) ? implode(', ', $cacheAgeforAliasLookup) : var_export($cacheAgeforAliasLookup, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->cacheAgeforAliasLookup = $cacheAgeforAliasLookup;
        return $this;
    }
}
