<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDevicePool StructType
 * @subpackage Structs
 */
class XDevicePool extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Not nullable.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The dateTimeSettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $dateTimeSettingName;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $regionName;
    /**
     * The srstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $srstName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - documentation: For IP Phones and Gateways. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The autoSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $autoSearchSpaceName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XCountry in AXLEnums.xsd
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The connectionMonitorDuration
     * Meta information extracted from the WSDL
     * - documentation: -1 means using system default
     * - default: -1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectionMonitorDuration;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Automated Alternate Routing. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mobilityCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Device Mobility. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mobilityCssName;
    /**
     * The physicalLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $physicalLocationName;
    /**
     * The deviceMobilityGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $deviceMobilityGroupName;
    /**
     * The revertPriority
     * Meta information extracted from the WSDL
     * - documentation: The value accepted and retrieved from the database for this field will be of type XRevertPriority in AXLEnums.xsd.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $revertPriority;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The localRouteGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $localRouteGroupName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The callingPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The adjunctCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $adjunctCallingSearchSpace;
    /**
     * The callingPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The localRouteGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocalRouteGroup[]
     */
    public $localRouteGroup;
    /**
     * The redirectingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $redirectingPartyTransformationCSS;
    /**
     * The callingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyTransformationCSS;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * Constructor method for XDevicePool
     * @uses XDevicePool::setName()
     * @uses XDevicePool::setDateTimeSettingName()
     * @uses XDevicePool::setCallManagerGroupName()
     * @uses XDevicePool::setRegionName()
     * @uses XDevicePool::setSrstName()
     * @uses XDevicePool::setAarNeighborhoodName()
     * @uses XDevicePool::setAutoSearchSpaceName()
     * @uses XDevicePool::setMediaResourceListName()
     * @uses XDevicePool::setNetworkLocale()
     * @uses XDevicePool::setConnectionMonitorDuration()
     * @uses XDevicePool::setAutomatedAlternateRoutingCssName()
     * @uses XDevicePool::setLocationName()
     * @uses XDevicePool::setMobilityCssName()
     * @uses XDevicePool::setPhysicalLocationName()
     * @uses XDevicePool::setDeviceMobilityGroupName()
     * @uses XDevicePool::setRevertPriority()
     * @uses XDevicePool::setSingleButtonBarge()
     * @uses XDevicePool::setJoinAcrossLines()
     * @uses XDevicePool::setCgpnTransformationCssName()
     * @uses XDevicePool::setCdpnTransformationCssName()
     * @uses XDevicePool::setLocalRouteGroupName()
     * @uses XDevicePool::setGeoLocationName()
     * @uses XDevicePool::setGeoLocationFilterName()
     * @uses XDevicePool::setCallingPartyNationalPrefix()
     * @uses XDevicePool::setCallingPartyInternationalPrefix()
     * @uses XDevicePool::setCallingPartyUnknownPrefix()
     * @uses XDevicePool::setCallingPartySubscriberPrefix()
     * @uses XDevicePool::setAdjunctCallingSearchSpace()
     * @uses XDevicePool::setCallingPartyNationalStripDigits()
     * @uses XDevicePool::setCallingPartyInternationalStripDigits()
     * @uses XDevicePool::setCallingPartyUnknownStripDigits()
     * @uses XDevicePool::setCallingPartySubscriberStripDigits()
     * @uses XDevicePool::setCallingPartyNationalTransformationCssName()
     * @uses XDevicePool::setCallingPartyInternationalTransformationCssName()
     * @uses XDevicePool::setCallingPartyUnknownTransformationCssName()
     * @uses XDevicePool::setCallingPartySubscriberTransformationCssName()
     * @uses XDevicePool::setCalledPartyNationalPrefix()
     * @uses XDevicePool::setCalledPartyInternationalPrefix()
     * @uses XDevicePool::setCalledPartyUnknownPrefix()
     * @uses XDevicePool::setCalledPartySubscriberPrefix()
     * @uses XDevicePool::setCalledPartyNationalStripDigits()
     * @uses XDevicePool::setCalledPartyInternationalStripDigits()
     * @uses XDevicePool::setCalledPartyUnknownStripDigits()
     * @uses XDevicePool::setCalledPartySubscriberStripDigits()
     * @uses XDevicePool::setCalledPartyNationalTransformationCssName()
     * @uses XDevicePool::setCalledPartyInternationalTransformationCssName()
     * @uses XDevicePool::setCalledPartyUnknownTransformationCssName()
     * @uses XDevicePool::setCalledPartySubscriberTransformationCssName()
     * @uses XDevicePool::setImeEnrolledPatternGroupName()
     * @uses XDevicePool::setCntdPnTransformationCssName()
     * @uses XDevicePool::setLocalRouteGroup()
     * @uses XDevicePool::setRedirectingPartyTransformationCSS()
     * @uses XDevicePool::setCallingPartyTransformationCSS()
     * @uses XDevicePool::setWirelessLanProfileGroup()
     * @param string $name
     * @param \StructType\XFkType $dateTimeSettingName
     * @param \StructType\XFkType $callManagerGroupName
     * @param \StructType\XFkType $regionName
     * @param \StructType\XFkType $srstName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XFkType $autoSearchSpaceName
     * @param \StructType\XFkType $mediaResourceListName
     * @param string $networkLocale
     * @param string $connectionMonitorDuration
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mobilityCssName
     * @param \StructType\XFkType $physicalLocationName
     * @param \StructType\XFkType $deviceMobilityGroupName
     * @param string $revertPriority
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param \StructType\XFkType $localRouteGroupName
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param \StructType\XFkType $adjunctCallingSearchSpace
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param \StructType\XFkType $imeEnrolledPatternGroupName
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @param \StructType\LocalRouteGroup[] $localRouteGroup
     * @param \StructType\XFkType $redirectingPartyTransformationCSS
     * @param \StructType\XFkType $callingPartyTransformationCSS
     * @param \StructType\XFkType $wirelessLanProfileGroup
     */
    public function __construct($name = null, \StructType\XFkType $dateTimeSettingName = null, \StructType\XFkType $callManagerGroupName = null, \StructType\XFkType $regionName = null, \StructType\XFkType $srstName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XFkType $autoSearchSpaceName = null, \StructType\XFkType $mediaResourceListName = null, $networkLocale = null, $connectionMonitorDuration = '-1', \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $locationName = null, \StructType\XFkType $mobilityCssName = null, \StructType\XFkType $physicalLocationName = null, \StructType\XFkType $deviceMobilityGroupName = null, $revertPriority = 'Default', $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', \StructType\XFkType $cgpnTransformationCssName = null, \StructType\XFkType $cdpnTransformationCssName = null, \StructType\XFkType $localRouteGroupName = null, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, \StructType\XFkType $adjunctCallingSearchSpace = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \StructType\XFkType $callingPartyNationalTransformationCssName = null, \StructType\XFkType $callingPartyInternationalTransformationCssName = null, \StructType\XFkType $callingPartyUnknownTransformationCssName = null, \StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \StructType\XFkType $calledPartyNationalTransformationCssName = null, \StructType\XFkType $calledPartyInternationalTransformationCssName = null, \StructType\XFkType $calledPartyUnknownTransformationCssName = null, \StructType\XFkType $calledPartySubscriberTransformationCssName = null, \StructType\XFkType $imeEnrolledPatternGroupName = null, \StructType\XFkType $cntdPnTransformationCssName = null, array $localRouteGroup = array(), \StructType\XFkType $redirectingPartyTransformationCSS = null, \StructType\XFkType $callingPartyTransformationCSS = null, \StructType\XFkType $wirelessLanProfileGroup = null)
    {
        $this
            ->setName($name)
            ->setDateTimeSettingName($dateTimeSettingName)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setRegionName($regionName)
            ->setSrstName($srstName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setAutoSearchSpaceName($autoSearchSpaceName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkLocale($networkLocale)
            ->setConnectionMonitorDuration($connectionMonitorDuration)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setLocationName($locationName)
            ->setMobilityCssName($mobilityCssName)
            ->setPhysicalLocationName($physicalLocationName)
            ->setDeviceMobilityGroupName($deviceMobilityGroupName)
            ->setRevertPriority($revertPriority)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setLocalRouteGroupName($localRouteGroupName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setAdjunctCallingSearchSpace($adjunctCallingSearchSpace)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setLocalRouteGroup($localRouteGroup)
            ->setRedirectingPartyTransformationCSS($redirectingPartyTransformationCSS)
            ->setCallingPartyTransformationCSS($callingPartyTransformationCSS)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XDevicePool
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dateTimeSettingName value
     * @return \StructType\XFkType
     */
    public function getDateTimeSettingName()
    {
        return $this->dateTimeSettingName;
    }
    /**
     * Set dateTimeSettingName value
     * @param \StructType\XFkType $dateTimeSettingName
     * @return \StructType\XDevicePool
     */
    public function setDateTimeSettingName(\StructType\XFkType $dateTimeSettingName = null)
    {
        $this->dateTimeSettingName = $dateTimeSettingName;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \StructType\XFkType
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\XDevicePool
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get regionName value
     * @return \StructType\XFkType
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \StructType\XFkType $regionName
     * @return \StructType\XDevicePool
     */
    public function setRegionName(\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get srstName value
     * @return \StructType\XFkType
     */
    public function getSrstName()
    {
        return $this->srstName;
    }
    /**
     * Set srstName value
     * @param \StructType\XFkType $srstName
     * @return \StructType\XDevicePool
     */
    public function setSrstName(\StructType\XFkType $srstName = null)
    {
        $this->srstName = $srstName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\XDevicePool
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get autoSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAutoSearchSpaceName()
    {
        return isset($this->autoSearchSpaceName) ? $this->autoSearchSpaceName : null;
    }
    /**
     * Set autoSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $autoSearchSpaceName
     * @return \StructType\XDevicePool
     */
    public function setAutoSearchSpaceName(\StructType\XFkType $autoSearchSpaceName = null)
    {
        if (is_null($autoSearchSpaceName) || (is_array($autoSearchSpaceName) && empty($autoSearchSpaceName))) {
            unset($this->autoSearchSpaceName);
        } else {
            $this->autoSearchSpaceName = $autoSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\XDevicePool
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\XDevicePool
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCountry', is_array($networkLocale) ? implode(', ', $networkLocale) : var_export($networkLocale, true), implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get connectionMonitorDuration value
     * @return string|null
     */
    public function getConnectionMonitorDuration()
    {
        return $this->connectionMonitorDuration;
    }
    /**
     * Set connectionMonitorDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionMonitorDuration
     * @return \StructType\XDevicePool
     */
    public function setConnectionMonitorDuration($connectionMonitorDuration = '-1')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($connectionMonitorDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($connectionMonitorDuration) ? implode(', ', $connectionMonitorDuration) : var_export($connectionMonitorDuration, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->connectionMonitorDuration = $connectionMonitorDuration;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\XDevicePool
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return isset($this->locationName) ? $this->locationName : null;
    }
    /**
     * Set locationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $locationName
     * @return \StructType\XDevicePool
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->locationName);
        } else {
            $this->locationName = $locationName;
        }
        return $this;
    }
    /**
     * Get mobilityCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMobilityCssName()
    {
        return isset($this->mobilityCssName) ? $this->mobilityCssName : null;
    }
    /**
     * Set mobilityCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mobilityCssName
     * @return \StructType\XDevicePool
     */
    public function setMobilityCssName(\StructType\XFkType $mobilityCssName = null)
    {
        if (is_null($mobilityCssName) || (is_array($mobilityCssName) && empty($mobilityCssName))) {
            unset($this->mobilityCssName);
        } else {
            $this->mobilityCssName = $mobilityCssName;
        }
        return $this;
    }
    /**
     * Get physicalLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getPhysicalLocationName()
    {
        return isset($this->physicalLocationName) ? $this->physicalLocationName : null;
    }
    /**
     * Set physicalLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $physicalLocationName
     * @return \StructType\XDevicePool
     */
    public function setPhysicalLocationName(\StructType\XFkType $physicalLocationName = null)
    {
        if (is_null($physicalLocationName) || (is_array($physicalLocationName) && empty($physicalLocationName))) {
            unset($this->physicalLocationName);
        } else {
            $this->physicalLocationName = $physicalLocationName;
        }
        return $this;
    }
    /**
     * Get deviceMobilityGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDeviceMobilityGroupName()
    {
        return isset($this->deviceMobilityGroupName) ? $this->deviceMobilityGroupName : null;
    }
    /**
     * Set deviceMobilityGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $deviceMobilityGroupName
     * @return \StructType\XDevicePool
     */
    public function setDeviceMobilityGroupName(\StructType\XFkType $deviceMobilityGroupName = null)
    {
        if (is_null($deviceMobilityGroupName) || (is_array($deviceMobilityGroupName) && empty($deviceMobilityGroupName))) {
            unset($this->deviceMobilityGroupName);
        } else {
            $this->deviceMobilityGroupName = $deviceMobilityGroupName;
        }
        return $this;
    }
    /**
     * Get revertPriority value
     * @return string|null
     */
    public function getRevertPriority()
    {
        return $this->revertPriority;
    }
    /**
     * Set revertPriority value
     * @uses \EnumType\XRevertPriority::valueIsValid()
     * @uses \EnumType\XRevertPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revertPriority
     * @return \StructType\XDevicePool
     */
    public function setRevertPriority($revertPriority = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRevertPriority::valueIsValid($revertPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRevertPriority', is_array($revertPriority) ? implode(', ', $revertPriority) : var_export($revertPriority, true), implode(', ', \EnumType\XRevertPriority::getValidValues())), __LINE__);
        }
        $this->revertPriority = $revertPriority;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \EnumType\XBarge::valueIsValid()
     * @uses \EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \StructType\XDevicePool
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XBarge', is_array($singleButtonBarge) ? implode(', ', $singleButtonBarge) : var_export($singleButtonBarge, true), implode(', ', \EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \StructType\XDevicePool
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($joinAcrossLines) ? implode(', ', $joinAcrossLines) : var_export($joinAcrossLines, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get localRouteGroupName value
     * @return \StructType\XFkType|null
     */
    public function getLocalRouteGroupName()
    {
        return $this->localRouteGroupName;
    }
    /**
     * Set localRouteGroupName value
     * @param \StructType\XFkType $localRouteGroupName
     * @return \StructType\XDevicePool
     */
    public function setLocalRouteGroupName(\StructType\XFkType $localRouteGroupName = null)
    {
        $this->localRouteGroupName = $localRouteGroupName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\XDevicePool
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\XDevicePool
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyNationalPrefix) && !is_string($callingPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyNationalPrefix, true), gettype($callingPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartyNationalPrefix) && mb_strlen($callingPartyNationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartyNationalPrefix)), __LINE__);
        }
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyInternationalPrefix) && !is_string($callingPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyInternationalPrefix, true), gettype($callingPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartyInternationalPrefix) && mb_strlen($callingPartyInternationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartyInternationalPrefix)), __LINE__);
        }
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyUnknownPrefix) && !is_string($callingPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyUnknownPrefix, true), gettype($callingPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartyUnknownPrefix) && mb_strlen($callingPartyUnknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartyUnknownPrefix)), __LINE__);
        }
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \StructType\XDevicePool
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartySubscriberPrefix) && !is_string($callingPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartySubscriberPrefix, true), gettype($callingPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartySubscriberPrefix) && mb_strlen($callingPartySubscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartySubscriberPrefix)), __LINE__);
        }
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get adjunctCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAdjunctCallingSearchSpace()
    {
        return isset($this->adjunctCallingSearchSpace) ? $this->adjunctCallingSearchSpace : null;
    }
    /**
     * Set adjunctCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $adjunctCallingSearchSpace
     * @return \StructType\XDevicePool
     */
    public function setAdjunctCallingSearchSpace(\StructType\XFkType $adjunctCallingSearchSpace = null)
    {
        if (is_null($adjunctCallingSearchSpace) || (is_array($adjunctCallingSearchSpace) && empty($adjunctCallingSearchSpace))) {
            unset($this->adjunctCallingSearchSpace);
        } else {
            $this->adjunctCallingSearchSpace = $adjunctCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return isset($this->callingPartyNationalStripDigits) ? $this->callingPartyNationalStripDigits : null;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNationalStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyNationalStripDigits) ? implode(', ', $callingPartyNationalStripDigits) : var_export($callingPartyNationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyNationalStripDigits) || (is_array($callingPartyNationalStripDigits) && empty($callingPartyNationalStripDigits))) {
            unset($this->callingPartyNationalStripDigits);
        } else {
            $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return isset($this->callingPartyInternationalStripDigits) ? $this->callingPartyInternationalStripDigits : null;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyInternationalStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyInternationalStripDigits) ? implode(', ', $callingPartyInternationalStripDigits) : var_export($callingPartyInternationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyInternationalStripDigits) || (is_array($callingPartyInternationalStripDigits) && empty($callingPartyInternationalStripDigits))) {
            unset($this->callingPartyInternationalStripDigits);
        } else {
            $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return isset($this->callingPartyUnknownStripDigits) ? $this->callingPartyUnknownStripDigits : null;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyUnknownStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyUnknownStripDigits) ? implode(', ', $callingPartyUnknownStripDigits) : var_export($callingPartyUnknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyUnknownStripDigits) || (is_array($callingPartyUnknownStripDigits) && empty($callingPartyUnknownStripDigits))) {
            unset($this->callingPartyUnknownStripDigits);
        } else {
            $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return isset($this->callingPartySubscriberStripDigits) ? $this->callingPartySubscriberStripDigits : null;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySubscriberStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartySubscriberStripDigits) ? implode(', ', $callingPartySubscriberStripDigits) : var_export($callingPartySubscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartySubscriberStripDigits) || (is_array($callingPartySubscriberStripDigits) && empty($callingPartySubscriberStripDigits))) {
            unset($this->callingPartySubscriberStripDigits);
        } else {
            $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return isset($this->callingPartyNationalTransformationCssName) ? $this->callingPartyNationalTransformationCssName : null;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyNationalTransformationCssName(\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        if (is_null($callingPartyNationalTransformationCssName) || (is_array($callingPartyNationalTransformationCssName) && empty($callingPartyNationalTransformationCssName))) {
            unset($this->callingPartyNationalTransformationCssName);
        } else {
            $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return isset($this->callingPartyInternationalTransformationCssName) ? $this->callingPartyInternationalTransformationCssName : null;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyInternationalTransformationCssName(\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        if (is_null($callingPartyInternationalTransformationCssName) || (is_array($callingPartyInternationalTransformationCssName) && empty($callingPartyInternationalTransformationCssName))) {
            unset($this->callingPartyInternationalTransformationCssName);
        } else {
            $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyUnknownTransformationCssName(\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return isset($this->callingPartySubscriberTransformationCssName) ? $this->callingPartySubscriberTransformationCssName : null;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCallingPartySubscriberTransformationCssName(\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        if (is_null($callingPartySubscriberTransformationCssName) || (is_array($callingPartySubscriberTransformationCssName) && empty($callingPartySubscriberTransformationCssName))) {
            unset($this->callingPartySubscriberTransformationCssName);
        } else {
            $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyNationalPrefix) && !is_string($calledPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyNationalPrefix, true), gettype($calledPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyNationalPrefix) && mb_strlen($calledPartyNationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyNationalPrefix)), __LINE__);
        }
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyInternationalPrefix) && !is_string($calledPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyInternationalPrefix, true), gettype($calledPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyInternationalPrefix) && mb_strlen($calledPartyInternationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyInternationalPrefix)), __LINE__);
        }
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyUnknownPrefix, true), gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyUnknownPrefix) && mb_strlen($calledPartyUnknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \StructType\XDevicePool
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartySubscriberPrefix) && !is_string($calledPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartySubscriberPrefix, true), gettype($calledPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartySubscriberPrefix) && mb_strlen($calledPartySubscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartySubscriberPrefix)), __LINE__);
        }
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNationalStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyNationalStripDigits) ? implode(', ', $calledPartyNationalStripDigits) : var_export($calledPartyNationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyInternationalStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyInternationalStripDigits) ? implode(', ', $calledPartyInternationalStripDigits) : var_export($calledPartyInternationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyUnknownStripDigits) ? implode(', ', $calledPartyUnknownStripDigits) : var_export($calledPartyUnknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartySubscriberStripDigits
     * @return \StructType\XDevicePool
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartySubscriberStripDigits) ? implode(', ', $calledPartySubscriberStripDigits) : var_export($calledPartySubscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyNationalTransformationCssName(\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyInternationalTransformationCssName(\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCalledPartyUnknownTransformationCssName(\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCalledPartySubscriberTransformationCssName(\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return isset($this->imeEnrolledPatternGroupName) ? $this->imeEnrolledPatternGroupName : null;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $imeEnrolledPatternGroupName
     * @return \StructType\XDevicePool
     */
    public function setImeEnrolledPatternGroupName(\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        if (is_null($imeEnrolledPatternGroupName) || (is_array($imeEnrolledPatternGroupName) && empty($imeEnrolledPatternGroupName))) {
            unset($this->imeEnrolledPatternGroupName);
        } else {
            $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        }
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @return \StructType\XDevicePool
     */
    public function setCntdPnTransformationCssName(\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get localRouteGroup value
     * @return \StructType\LocalRouteGroup[]|null
     */
    public function getLocalRouteGroup()
    {
        return $this->localRouteGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalRouteGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalRouteGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalRouteGroupForArrayConstraintsFromSetLocalRouteGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xDevicePoolLocalRouteGroupItem) {
            // validation for constraint: itemType
            if (!$xDevicePoolLocalRouteGroupItem instanceof \StructType\LocalRouteGroup) {
                $invalidValues[] = is_object($xDevicePoolLocalRouteGroupItem) ? get_class($xDevicePoolLocalRouteGroupItem) : sprintf('%s(%s)', gettype($xDevicePoolLocalRouteGroupItem), var_export($xDevicePoolLocalRouteGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The localRouteGroup property can only contain items of type \StructType\LocalRouteGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set localRouteGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\LocalRouteGroup[] $localRouteGroup
     * @return \StructType\XDevicePool
     */
    public function setLocalRouteGroup(array $localRouteGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($localRouteGroupArrayErrorMessage = self::validateLocalRouteGroupForArrayConstraintsFromSetLocalRouteGroup($localRouteGroup))) {
            throw new \InvalidArgumentException($localRouteGroupArrayErrorMessage, __LINE__);
        }
        $this->localRouteGroup = $localRouteGroup;
        return $this;
    }
    /**
     * Add item to localRouteGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\LocalRouteGroup $item
     * @return \StructType\XDevicePool
     */
    public function addToLocalRouteGroup(\StructType\LocalRouteGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocalRouteGroup) {
            throw new \InvalidArgumentException(sprintf('The localRouteGroup property can only contain items of type \StructType\LocalRouteGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->localRouteGroup[] = $item;
        return $this;
    }
    /**
     * Get redirectingPartyTransformationCSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRedirectingPartyTransformationCSS()
    {
        return isset($this->redirectingPartyTransformationCSS) ? $this->redirectingPartyTransformationCSS : null;
    }
    /**
     * Set redirectingPartyTransformationCSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $redirectingPartyTransformationCSS
     * @return \StructType\XDevicePool
     */
    public function setRedirectingPartyTransformationCSS(\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        if (is_null($redirectingPartyTransformationCSS) || (is_array($redirectingPartyTransformationCSS) && empty($redirectingPartyTransformationCSS))) {
            unset($this->redirectingPartyTransformationCSS);
        } else {
            $this->redirectingPartyTransformationCSS = $redirectingPartyTransformationCSS;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationCSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSS()
    {
        return isset($this->callingPartyTransformationCSS) ? $this->callingPartyTransformationCSS : null;
    }
    /**
     * Set callingPartyTransformationCSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyTransformationCSS
     * @return \StructType\XDevicePool
     */
    public function setCallingPartyTransformationCSS(\StructType\XFkType $callingPartyTransformationCSS = null)
    {
        if (is_null($callingPartyTransformationCSS) || (is_array($callingPartyTransformationCSS) && empty($callingPartyTransformationCSS))) {
            unset($this->callingPartyTransformationCSS);
        } else {
            $this->callingPartyTransformationCSS = $callingPartyTransformationCSS;
        }
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return isset($this->wirelessLanProfileGroup) ? $this->wirelessLanProfileGroup : null;
    }
    /**
     * Set wirelessLanProfileGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $wirelessLanProfileGroup
     * @return \StructType\XDevicePool
     */
    public function setWirelessLanProfileGroup(\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        if (is_null($wirelessLanProfileGroup) || (is_array($wirelessLanProfileGroup) && empty($wirelessLanProfileGroup))) {
            unset($this->wirelessLanProfileGroup);
        } else {
            $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        }
        return $this;
    }
}
