<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDdi StructType
 * @subpackage Structs
 */
class XDdi extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The clause
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $clause;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * Constructor method for XDdi
     * @uses XDdi::setName()
     * @uses XDdi::setDialPlanName()
     * @uses XDdi::setClause()
     * @uses XDdi::setMembers()
     * @param string $name
     * @param \StructType\XFkType $dialPlanName
     * @param string $clause
     * @param \StructType\Members $members
     */
    public function __construct($name = null, \StructType\XFkType $dialPlanName = null, $clause = null, \StructType\Members $members = null)
    {
        $this
            ->setName($name)
            ->setDialPlanName($dialPlanName)
            ->setClause($clause)
            ->setMembers($members);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XDdi
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \StructType\XFkType
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \StructType\XFkType $dialPlanName
     * @return \StructType\XDdi
     */
    public function setDialPlanName(\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get clause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClause()
    {
        return isset($this->clause) ? $this->clause : null;
    }
    /**
     * Set clause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clause
     * @return \StructType\XDdi
     */
    public function setClause($clause = null)
    {
        // validation for constraint: string
        if (!is_null($clause) && !is_string($clause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clause, true), gettype($clause)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($clause) && mb_strlen($clause) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($clause)), __LINE__);
        }
        if (is_null($clause) || (is_array($clause) && empty($clause))) {
            unset($this->clause);
        } else {
            $this->clause = $clause;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XDdi
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
}
