<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCredentialPolicyDefault StructType
 * @subpackage Structs
 */
class XCredentialPolicyDefault extends AbstractStructBase
{
    /**
     * The credPolicyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $credPolicyName;
    /**
     * The credentialUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $credentialUser;
    /**
     * The credentialType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $credentialType;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $credentials;
    /**
     * The confirmCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confirmCredentials;
    /**
     * The credUserCantChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserCantChange;
    /**
     * The credUserMustChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserMustChange;
    /**
     * The credDoesNotExpire
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credDoesNotExpire;
    /**
     * Constructor method for XCredentialPolicyDefault
     * @uses XCredentialPolicyDefault::setCredPolicyName()
     * @uses XCredentialPolicyDefault::setCredentialUser()
     * @uses XCredentialPolicyDefault::setCredentialType()
     * @uses XCredentialPolicyDefault::setCredentials()
     * @uses XCredentialPolicyDefault::setConfirmCredentials()
     * @uses XCredentialPolicyDefault::setCredUserCantChange()
     * @uses XCredentialPolicyDefault::setCredUserMustChange()
     * @uses XCredentialPolicyDefault::setCredDoesNotExpire()
     * @param \StructType\XFkType $credPolicyName
     * @param string $credentialUser
     * @param string $credentialType
     * @param string $credentials
     * @param string $confirmCredentials
     * @param string $credUserCantChange
     * @param string $credUserMustChange
     * @param string $credDoesNotExpire
     */
    public function __construct(\StructType\XFkType $credPolicyName = null, $credentialUser = null, $credentialType = null, $credentials = null, $confirmCredentials = null, $credUserCantChange = 'false', $credUserMustChange = 'true', $credDoesNotExpire = 'false')
    {
        $this
            ->setCredPolicyName($credPolicyName)
            ->setCredentialUser($credentialUser)
            ->setCredentialType($credentialType)
            ->setCredentials($credentials)
            ->setConfirmCredentials($confirmCredentials)
            ->setCredUserCantChange($credUserCantChange)
            ->setCredUserMustChange($credUserMustChange)
            ->setCredDoesNotExpire($credDoesNotExpire);
    }
    /**
     * Get credPolicyName value
     * @return \StructType\XFkType
     */
    public function getCredPolicyName()
    {
        return $this->credPolicyName;
    }
    /**
     * Set credPolicyName value
     * @param \StructType\XFkType $credPolicyName
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredPolicyName(\StructType\XFkType $credPolicyName = null)
    {
        $this->credPolicyName = $credPolicyName;
        return $this;
    }
    /**
     * Get credentialUser value
     * @return string|null
     */
    public function getCredentialUser()
    {
        return $this->credentialUser;
    }
    /**
     * Set credentialUser value
     * @uses \EnumType\XCredentialUser::valueIsValid()
     * @uses \EnumType\XCredentialUser::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialUser
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredentialUser($credentialUser = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCredentialUser::valueIsValid($credentialUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCredentialUser', is_array($credentialUser) ? implode(', ', $credentialUser) : var_export($credentialUser, true), implode(', ', \EnumType\XCredentialUser::getValidValues())), __LINE__);
        }
        $this->credentialUser = $credentialUser;
        return $this;
    }
    /**
     * Get credentialType value
     * @return string|null
     */
    public function getCredentialType()
    {
        return $this->credentialType;
    }
    /**
     * Set credentialType value
     * @uses \EnumType\XCredential::valueIsValid()
     * @uses \EnumType\XCredential::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialType
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredentialType($credentialType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCredential::valueIsValid($credentialType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCredential', is_array($credentialType) ? implode(', ', $credentialType) : var_export($credentialType, true), implode(', ', \EnumType\XCredential::getValidValues())), __LINE__);
        }
        $this->credentialType = $credentialType;
        return $this;
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $credentials
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredentials($credentials = null)
    {
        // validation for constraint: string
        if (!is_null($credentials) && !is_string($credentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credentials, true), gettype($credentials)), __LINE__);
        }
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get confirmCredentials value
     * @return string|null
     */
    public function getConfirmCredentials()
    {
        return $this->confirmCredentials;
    }
    /**
     * Set confirmCredentials value
     * @param string $confirmCredentials
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setConfirmCredentials($confirmCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($confirmCredentials) && !is_string($confirmCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmCredentials, true), gettype($confirmCredentials)), __LINE__);
        }
        $this->confirmCredentials = $confirmCredentials;
        return $this;
    }
    /**
     * Get credUserCantChange value
     * @return string|null
     */
    public function getCredUserCantChange()
    {
        return $this->credUserCantChange;
    }
    /**
     * Set credUserCantChange value
     * @param string $credUserCantChange
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredUserCantChange($credUserCantChange = 'false')
    {
        // validation for constraint: string
        if (!is_null($credUserCantChange) && !is_string($credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credUserCantChange, true), gettype($credUserCantChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credUserCantChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credUserCantChange, true)), __LINE__);
        }
        $this->credUserCantChange = $credUserCantChange;
        return $this;
    }
    /**
     * Get credUserMustChange value
     * @return string|null
     */
    public function getCredUserMustChange()
    {
        return $this->credUserMustChange;
    }
    /**
     * Set credUserMustChange value
     * @param string $credUserMustChange
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredUserMustChange($credUserMustChange = 'true')
    {
        // validation for constraint: string
        if (!is_null($credUserMustChange) && !is_string($credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credUserMustChange, true), gettype($credUserMustChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credUserMustChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credUserMustChange, true)), __LINE__);
        }
        $this->credUserMustChange = $credUserMustChange;
        return $this;
    }
    /**
     * Get credDoesNotExpire value
     * @return string|null
     */
    public function getCredDoesNotExpire()
    {
        return $this->credDoesNotExpire;
    }
    /**
     * Set credDoesNotExpire value
     * @param string $credDoesNotExpire
     * @return \StructType\XCredentialPolicyDefault
     */
    public function setCredDoesNotExpire($credDoesNotExpire = 'false')
    {
        // validation for constraint: string
        if (!is_null($credDoesNotExpire) && !is_string($credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credDoesNotExpire, true), gettype($credDoesNotExpire)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credDoesNotExpire) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credDoesNotExpire, true)), __LINE__);
        }
        $this->credDoesNotExpire = $credDoesNotExpire;
        return $this;
    }
}
