<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallForwardAlternateParty StructType
 * @subpackage Structs
 */
class XCallForwardAlternateParty extends AbstractStructBase
{
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $destination;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for callForwardNoAnswer and callForwardAlternateParty,Value "-1" in the response indicates that the CM will use the default setting
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $duration;
    /**
     * Constructor method for XCallForwardAlternateParty
     * @uses XCallForwardAlternateParty::setCallingSearchSpaceName()
     * @uses XCallForwardAlternateParty::setDestination()
     * @uses XCallForwardAlternateParty::setDuration()
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param string $destination
     * @param string $duration
     */
    public function __construct(\StructType\XFkType $callingSearchSpaceName = null, $destination = null, $duration = null)
    {
        $this
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination)
            ->setDuration($duration);
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\XCallForwardAlternateParty
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * Set destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\XCallForwardAlternateParty
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($destination) && mb_strlen($destination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Get duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duration
     * @return \StructType\XCallForwardAlternateParty
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($duration) ? implode(', ', $duration) : var_export($duration, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
}
