<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAarGroupMatrix StructType
 * @subpackage Structs
 */
class XAarGroupMatrix extends AbstractStructBase
{
    /**
     * The aarGroupFromName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * The prefixDigit
     * Meta information extracted from the WSDL
     * - documentation: The new prefixDigit value for this particular AARGroup relationship.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefixDigit;
    /**
     * Constructor method for XAarGroupMatrix
     * @uses XAarGroupMatrix::setAarGroupFromName()
     * @uses XAarGroupMatrix::setAarGroupToName()
     * @uses XAarGroupMatrix::setPrefixDigit()
     * @param \StructType\XFkType $aarGroupFromName
     * @param \StructType\XFkType $aarGroupToName
     * @param string $prefixDigit
     */
    public function __construct(\StructType\XFkType $aarGroupFromName = null, \StructType\XFkType $aarGroupToName = null, $prefixDigit = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setPrefixDigit($prefixDigit);
    }
    /**
     * Get aarGroupFromName value
     * @return \StructType\XFkType
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param \StructType\XFkType $aarGroupFromName
     * @return \StructType\XAarGroupMatrix
     */
    public function setAarGroupFromName(\StructType\XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \StructType\XFkType
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param \StructType\XFkType $aarGroupToName
     * @return \StructType\XAarGroupMatrix
     */
    public function setAarGroupToName(\StructType\XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \StructType\XAarGroupMatrix
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigit, true), gettype($prefixDigit)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prefixDigit) && mb_strlen($prefixDigit) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
}
