<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTvsCertificateReq StructType
 * @subpackage Structs
 */
class UpdateTvsCertificateReq extends APIRequest
{
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serialNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The timeToLive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $timeToLive;
    /**
     * Constructor method for UpdateTvsCertificateReq
     * @uses UpdateTvsCertificateReq::setIssuerName()
     * @uses UpdateTvsCertificateReq::setSerialNumber()
     * @uses UpdateTvsCertificateReq::setUuid()
     * @uses UpdateTvsCertificateReq::setTimeToLive()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $uuid
     * @param int $timeToLive
     */
    public function __construct($issuerName = null, $serialNumber = null, $uuid = null, $timeToLive = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setUuid($uuid)
            ->setTimeToLive($timeToLive);
    }
    /**
     * Get issuerName value
     * @return string
     */
    public function getIssuerName()
    {
        return isset($this->issuerName) ? $this->issuerName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIssuerName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssuerName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIssuerNameForChoiceConstraintsFromSetIssuerName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'serialNumber',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property issuerName can\'t be set as the property %s is already set. Only one property must be set among these properties: issuerName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set issuerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $issuerName
     * @return \StructType\UpdateTvsCertificateReq
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerName, true), gettype($issuerName)), __LINE__);
        }
        // validation for constraint: choice(uuid, issuerName, serialNumber)
        if ('' !== ($issuerNameChoiceErrorMessage = self::validateIssuerNameForChoiceConstraintsFromSetIssuerName($issuerName))) {
            throw new \InvalidArgumentException($issuerNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($issuerName) || (is_array($issuerName) && empty($issuerName))) {
            unset($this->issuerName);
        } else {
            $this->issuerName = $issuerName;
        }
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string
     */
    public function getSerialNumber()
    {
        return isset($this->serialNumber) ? $this->serialNumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSerialNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerialNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSerialNumberForChoiceConstraintsFromSetSerialNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'issuerName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property serialNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: serialNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set serialNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $serialNumber
     * @return \StructType\UpdateTvsCertificateReq
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        // validation for constraint: choice(uuid, issuerName, serialNumber)
        if ('' !== ($serialNumberChoiceErrorMessage = self::validateSerialNumberForChoiceConstraintsFromSetSerialNumber($serialNumber))) {
            throw new \InvalidArgumentException($serialNumberChoiceErrorMessage, __LINE__);
        }
        if (is_null($serialNumber) || (is_array($serialNumber) && empty($serialNumber))) {
            unset($this->serialNumber);
        } else {
            $this->serialNumber = $serialNumber;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'issuerName',
            'serialNumber',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateTvsCertificateReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, issuerName, serialNumber)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get timeToLive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimeToLive()
    {
        return isset($this->timeToLive) ? $this->timeToLive : null;
    }
    /**
     * Set timeToLive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timeToLive
     * @return \StructType\UpdateTvsCertificateReq
     */
    public function setTimeToLive($timeToLive = null)
    {
        // validation for constraint: int
        if (!is_null($timeToLive) && !(is_int($timeToLive) || ctype_digit($timeToLive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeToLive, true), gettype($timeToLive)), __LINE__);
        }
        if (is_null($timeToLive) || (is_array($timeToLive) && empty($timeToLive))) {
            unset($this->timeToLive);
        } else {
            $this->timeToLive = $timeToLive;
        }
        return $this;
    }
}
