<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTimeScheduleReq StructType
 * @subpackage Structs
 */
class UpdateTimeScheduleReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The removeMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The timeScheduleCategory
     * Meta information extracted from the WSDL
     * - default: Regular
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * Constructor method for UpdateTimeScheduleReq
     * @uses UpdateTimeScheduleReq::setNewName()
     * @uses UpdateTimeScheduleReq::setRemoveMembers()
     * @uses UpdateTimeScheduleReq::setAddMembers()
     * @uses UpdateTimeScheduleReq::setMembers()
     * @uses UpdateTimeScheduleReq::setDescription()
     * @uses UpdateTimeScheduleReq::setTimeScheduleCategory()
     * @param string $newName
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param string $description
     * @param string $timeScheduleCategory
     */
    public function __construct($newName = null, \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, $description = null, $timeScheduleCategory = 'Regular')
    {
        $this
            ->setNewName($newName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setDescription($description)
            ->setTimeScheduleCategory($timeScheduleCategory);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateTimeScheduleReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return isset($this->removeMembers) ? $this->removeMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: removeMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateTimeScheduleReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($removeMembersChoiceErrorMessage = self::validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($removeMembers))) {
            throw new \InvalidArgumentException($removeMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeMembers) || (is_array($removeMembers) && empty($removeMembers))) {
            unset($this->removeMembers);
        } else {
            $this->removeMembers = $removeMembers;
        }
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return isset($this->addMembers) ? $this->addMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddMembersForChoiceConstraintsFromSetAddMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: addMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateTimeScheduleReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($addMembersChoiceErrorMessage = self::validateAddMembersForChoiceConstraintsFromSetAddMembers($addMembers))) {
            throw new \InvalidArgumentException($addMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($addMembers) || (is_array($addMembers) && empty($addMembers))) {
            unset($this->addMembers);
        } else {
            $this->addMembers = $addMembers;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMembersForChoiceConstraintsFromSetMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'addMembers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property members can\'t be set as the property %s is already set. Only one property must be set among these properties: members, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set members value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Members $members
     * @return \StructType\UpdateTimeScheduleReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($membersChoiceErrorMessage = self::validateMembersForChoiceConstraintsFromSetMembers($members))) {
            throw new \InvalidArgumentException($membersChoiceErrorMessage, __LINE__);
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateTimeScheduleReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @uses \EnumType\XTimeScheduleCategory::valueIsValid()
     * @uses \EnumType\XTimeScheduleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeScheduleCategory
     * @return \StructType\UpdateTimeScheduleReq
     */
    public function setTimeScheduleCategory($timeScheduleCategory = 'Regular')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeScheduleCategory::valueIsValid($timeScheduleCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeScheduleCategory', is_array($timeScheduleCategory) ? implode(', ', $timeScheduleCategory) : var_export($timeScheduleCategory, true), implode(', ', \EnumType\XTimeScheduleCategory::getValidValues())), __LINE__);
        }
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
}
