<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGatekeeperReq StructType
 * @subpackage Structs
 */
class UpdateGatekeeperReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The rrqTimeToLive
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 300
     * - default: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 600
     * - default: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $retryTimeout;
    /**
     * The enableDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * Constructor method for UpdateGatekeeperReq
     * @uses UpdateGatekeeperReq::setNewName()
     * @uses UpdateGatekeeperReq::setDescription()
     * @uses UpdateGatekeeperReq::setRrqTimeToLive()
     * @uses UpdateGatekeeperReq::setRetryTimeout()
     * @uses UpdateGatekeeperReq::setEnableDevice()
     * @param string $newName
     * @param string $description
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $enableDevice
     */
    public function __construct($newName = null, $description = null, $rrqTimeToLive = '60', $retryTimeout = '300', $enableDevice = 'true')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setEnableDevice($enableDevice);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($newName) && mb_strlen($newName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string|null
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rrqTimeToLive
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setRrqTimeToLive($rrqTimeToLive = '60')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($rrqTimeToLive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($rrqTimeToLive) ? implode(', ', $rrqTimeToLive) : var_export($rrqTimeToLive, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string|null
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryTimeout
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setRetryTimeout($retryTimeout = '300')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($retryTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($retryTimeout) ? implode(', ', $retryTimeout) : var_export($retryTimeout, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setEnableDevice($enableDevice = 'true')
    {
        // validation for constraint: string
        if (!is_null($enableDevice) && !is_string($enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableDevice, true), gettype($enableDevice)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableDevice, true)), __LINE__);
        }
        $this->enableDevice = $enableDevice;
        return $this;
    }
}
