<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFallbackFeatureConfigReq StructType
 * @subpackage Structs
 */
class UpdateFallbackFeatureConfigReq extends AbstractStructBase
{
    /**
     * The enableFallbackForImeCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableFallbackForImeCalls;
    /**
     * The qosSensistivityLevel
     * Meta information extracted from the WSDL
     * - documentation: Valid Values are from 0 to 5
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The dtmfCorrelationDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtmfCorrelationDigits;
    /**
     * The dtmfCollectionTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtmfCollectionTimer;
    /**
     * The callAnswerTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The clearImeCallDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $clearImeCallDelayTimer;
    /**
     * The dtmfInterDigitDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtmfInterDigitDelayTimer;
    /**
     * The postConnectFallbackDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postConnectFallbackDelayTimer;
    /**
     * The fallbackSplitDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fallbackSplitDelayTimer;
    /**
     * The callCss
     * Meta information extracted from the WSDL
     * - documentation: Valid Values are 0 and 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callCss;
    /**
     * Constructor method for UpdateFallbackFeatureConfigReq
     * @uses UpdateFallbackFeatureConfigReq::setEnableFallbackForImeCalls()
     * @uses UpdateFallbackFeatureConfigReq::setQosSensistivityLevel()
     * @uses UpdateFallbackFeatureConfigReq::setDtmfCorrelationDigits()
     * @uses UpdateFallbackFeatureConfigReq::setDtmfCollectionTimer()
     * @uses UpdateFallbackFeatureConfigReq::setCallAnswerTimer()
     * @uses UpdateFallbackFeatureConfigReq::setClearImeCallDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setDtmfInterDigitDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setPostConnectFallbackDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setFallbackSplitDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setCallCss()
     * @param string $enableFallbackForImeCalls
     * @param string $qosSensistivityLevel
     * @param string $dtmfCorrelationDigits
     * @param string $dtmfCollectionTimer
     * @param string $callAnswerTimer
     * @param string $clearImeCallDelayTimer
     * @param string $dtmfInterDigitDelayTimer
     * @param string $postConnectFallbackDelayTimer
     * @param string $fallbackSplitDelayTimer
     * @param string $callCss
     */
    public function __construct($enableFallbackForImeCalls = null, $qosSensistivityLevel = null, $dtmfCorrelationDigits = null, $dtmfCollectionTimer = null, $callAnswerTimer = null, $clearImeCallDelayTimer = null, $dtmfInterDigitDelayTimer = null, $postConnectFallbackDelayTimer = null, $fallbackSplitDelayTimer = null, $callCss = null)
    {
        $this
            ->setEnableFallbackForImeCalls($enableFallbackForImeCalls)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setDtmfCorrelationDigits($dtmfCorrelationDigits)
            ->setDtmfCollectionTimer($dtmfCollectionTimer)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setClearImeCallDelayTimer($clearImeCallDelayTimer)
            ->setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer)
            ->setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer)
            ->setFallbackSplitDelayTimer($fallbackSplitDelayTimer)
            ->setCallCss($callCss);
    }
    /**
     * Get enableFallbackForImeCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnableFallbackForImeCalls()
    {
        return isset($this->enableFallbackForImeCalls) ? $this->enableFallbackForImeCalls : null;
    }
    /**
     * Set enableFallbackForImeCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enableFallbackForImeCalls
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setEnableFallbackForImeCalls($enableFallbackForImeCalls = null)
    {
        // validation for constraint: string
        if (!is_null($enableFallbackForImeCalls) && !is_string($enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableFallbackForImeCalls, true), gettype($enableFallbackForImeCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableFallbackForImeCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableFallbackForImeCalls, true)), __LINE__);
        }
        if (is_null($enableFallbackForImeCalls) || (is_array($enableFallbackForImeCalls) && empty($enableFallbackForImeCalls))) {
            unset($this->enableFallbackForImeCalls);
        } else {
            $this->enableFallbackForImeCalls = $enableFallbackForImeCalls;
        }
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return isset($this->qosSensistivityLevel) ? $this->qosSensistivityLevel : null;
    }
    /**
     * Set qosSensistivityLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($qosSensistivityLevel) ? implode(', ', $qosSensistivityLevel) : var_export($qosSensistivityLevel, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($qosSensistivityLevel) || (is_array($qosSensistivityLevel) && empty($qosSensistivityLevel))) {
            unset($this->qosSensistivityLevel);
        } else {
            $this->qosSensistivityLevel = $qosSensistivityLevel;
        }
        return $this;
    }
    /**
     * Get dtmfCorrelationDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtmfCorrelationDigits()
    {
        return isset($this->dtmfCorrelationDigits) ? $this->dtmfCorrelationDigits : null;
    }
    /**
     * Set dtmfCorrelationDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCorrelationDigits
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setDtmfCorrelationDigits($dtmfCorrelationDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dtmfCorrelationDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dtmfCorrelationDigits) ? implode(', ', $dtmfCorrelationDigits) : var_export($dtmfCorrelationDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($dtmfCorrelationDigits) || (is_array($dtmfCorrelationDigits) && empty($dtmfCorrelationDigits))) {
            unset($this->dtmfCorrelationDigits);
        } else {
            $this->dtmfCorrelationDigits = $dtmfCorrelationDigits;
        }
        return $this;
    }
    /**
     * Get dtmfCollectionTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtmfCollectionTimer()
    {
        return isset($this->dtmfCollectionTimer) ? $this->dtmfCollectionTimer : null;
    }
    /**
     * Set dtmfCollectionTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCollectionTimer
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setDtmfCollectionTimer($dtmfCollectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dtmfCollectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dtmfCollectionTimer) ? implode(', ', $dtmfCollectionTimer) : var_export($dtmfCollectionTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($dtmfCollectionTimer) || (is_array($dtmfCollectionTimer) && empty($dtmfCollectionTimer))) {
            unset($this->dtmfCollectionTimer);
        } else {
            $this->dtmfCollectionTimer = $dtmfCollectionTimer;
        }
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return isset($this->callAnswerTimer) ? $this->callAnswerTimer : null;
    }
    /**
     * Set callAnswerTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callAnswerTimer) ? implode(', ', $callAnswerTimer) : var_export($callAnswerTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callAnswerTimer) || (is_array($callAnswerTimer) && empty($callAnswerTimer))) {
            unset($this->callAnswerTimer);
        } else {
            $this->callAnswerTimer = $callAnswerTimer;
        }
        return $this;
    }
    /**
     * Get clearImeCallDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClearImeCallDelayTimer()
    {
        return isset($this->clearImeCallDelayTimer) ? $this->clearImeCallDelayTimer : null;
    }
    /**
     * Set clearImeCallDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clearImeCallDelayTimer
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setClearImeCallDelayTimer($clearImeCallDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($clearImeCallDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($clearImeCallDelayTimer) ? implode(', ', $clearImeCallDelayTimer) : var_export($clearImeCallDelayTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($clearImeCallDelayTimer) || (is_array($clearImeCallDelayTimer) && empty($clearImeCallDelayTimer))) {
            unset($this->clearImeCallDelayTimer);
        } else {
            $this->clearImeCallDelayTimer = $clearImeCallDelayTimer;
        }
        return $this;
    }
    /**
     * Get dtmfInterDigitDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtmfInterDigitDelayTimer()
    {
        return isset($this->dtmfInterDigitDelayTimer) ? $this->dtmfInterDigitDelayTimer : null;
    }
    /**
     * Set dtmfInterDigitDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfInterDigitDelayTimer
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dtmfInterDigitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dtmfInterDigitDelayTimer) ? implode(', ', $dtmfInterDigitDelayTimer) : var_export($dtmfInterDigitDelayTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($dtmfInterDigitDelayTimer) || (is_array($dtmfInterDigitDelayTimer) && empty($dtmfInterDigitDelayTimer))) {
            unset($this->dtmfInterDigitDelayTimer);
        } else {
            $this->dtmfInterDigitDelayTimer = $dtmfInterDigitDelayTimer;
        }
        return $this;
    }
    /**
     * Get postConnectFallbackDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostConnectFallbackDelayTimer()
    {
        return isset($this->postConnectFallbackDelayTimer) ? $this->postConnectFallbackDelayTimer : null;
    }
    /**
     * Set postConnectFallbackDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postConnectFallbackDelayTimer
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($postConnectFallbackDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($postConnectFallbackDelayTimer) ? implode(', ', $postConnectFallbackDelayTimer) : var_export($postConnectFallbackDelayTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($postConnectFallbackDelayTimer) || (is_array($postConnectFallbackDelayTimer) && empty($postConnectFallbackDelayTimer))) {
            unset($this->postConnectFallbackDelayTimer);
        } else {
            $this->postConnectFallbackDelayTimer = $postConnectFallbackDelayTimer;
        }
        return $this;
    }
    /**
     * Get fallbackSplitDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFallbackSplitDelayTimer()
    {
        return isset($this->fallbackSplitDelayTimer) ? $this->fallbackSplitDelayTimer : null;
    }
    /**
     * Set fallbackSplitDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fallbackSplitDelayTimer
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setFallbackSplitDelayTimer($fallbackSplitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($fallbackSplitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($fallbackSplitDelayTimer) ? implode(', ', $fallbackSplitDelayTimer) : var_export($fallbackSplitDelayTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($fallbackSplitDelayTimer) || (is_array($fallbackSplitDelayTimer) && empty($fallbackSplitDelayTimer))) {
            unset($this->fallbackSplitDelayTimer);
        } else {
            $this->fallbackSplitDelayTimer = $fallbackSplitDelayTimer;
        }
        return $this;
    }
    /**
     * Get callCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallCss()
    {
        return isset($this->callCss) ? $this->callCss : null;
    }
    /**
     * Set callCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \StructType\UpdateFallbackFeatureConfigReq
     */
    public function setCallCss($callCss = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callCss) ? implode(', ', $callCss) : var_export($callCss, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callCss) || (is_array($callCss) && empty($callCss))) {
            unset($this->callCss);
        } else {
            $this->callCss = $callCss;
        }
        return $this;
    }
}
