<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFacInfoReq StructType
 * @subpackage Structs
 */
class UpdateFacInfoReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $code;
    /**
     * The authorizationLevel
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authorizationLevel;
    /**
     * Constructor method for UpdateFacInfoReq
     * @uses UpdateFacInfoReq::setNewName()
     * @uses UpdateFacInfoReq::setCode()
     * @uses UpdateFacInfoReq::setAuthorizationLevel()
     * @param string $newName
     * @param string $code
     * @param string $authorizationLevel
     */
    public function __construct($newName = null, $code = null, $authorizationLevel = '0')
    {
        $this
            ->setNewName($newName)
            ->setCode($code)
            ->setAuthorizationLevel($authorizationLevel);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateFacInfoReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\UpdateFacInfoReq
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($code) && mb_strlen($code) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get authorizationLevel value
     * @return string|null
     */
    public function getAuthorizationLevel()
    {
        return $this->authorizationLevel;
    }
    /**
     * Set authorizationLevel value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authorizationLevel
     * @return \StructType\UpdateFacInfoReq
     */
    public function setAuthorizationLevel($authorizationLevel = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($authorizationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($authorizationLevel) ? implode(', ', $authorizationLevel) : var_export($authorizationLevel, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->authorizationLevel = $authorizationLevel;
        return $this;
    }
}
