<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDhcpServerReq StructType
 * @subpackage Structs
 */
class UpdateDhcpServerReq extends APIRequest
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - choice: uuid | processNodeName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $processNodeName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | processNodeName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newProcessNodeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $newProcessNodeName;
    /**
     * The primaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The primaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryTftpServerIpAddress;
    /**
     * The secondaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryTftpServerIpAddress;
    /**
     * The bootstrapServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bootstrapServerIpAddress;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The tftpServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tftpServerName;
    /**
     * The arpCacheTimeout
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $arpCacheTimeout;
    /**
     * The ipAddressLeaseTime
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressLeaseTime;
    /**
     * The renewalTime
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $renewalTime;
    /**
     * The rebindingTime
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rebindingTime;
    /**
     * Constructor method for UpdateDhcpServerReq
     * @uses UpdateDhcpServerReq::setProcessNodeName()
     * @uses UpdateDhcpServerReq::setUuid()
     * @uses UpdateDhcpServerReq::setNewProcessNodeName()
     * @uses UpdateDhcpServerReq::setPrimaryDnsIpAddress()
     * @uses UpdateDhcpServerReq::setSecondaryDnsIpAddress()
     * @uses UpdateDhcpServerReq::setPrimaryTftpServerIpAddress()
     * @uses UpdateDhcpServerReq::setSecondaryTftpServerIpAddress()
     * @uses UpdateDhcpServerReq::setBootstrapServerIpAddress()
     * @uses UpdateDhcpServerReq::setDomainName()
     * @uses UpdateDhcpServerReq::setTftpServerName()
     * @uses UpdateDhcpServerReq::setArpCacheTimeout()
     * @uses UpdateDhcpServerReq::setIpAddressLeaseTime()
     * @uses UpdateDhcpServerReq::setRenewalTime()
     * @uses UpdateDhcpServerReq::setRebindingTime()
     * @param \StructType\XFkType $processNodeName
     * @param string $uuid
     * @param \StructType\XFkType $newProcessNodeName
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $primaryTftpServerIpAddress
     * @param string $secondaryTftpServerIpAddress
     * @param string $bootstrapServerIpAddress
     * @param string $domainName
     * @param string $tftpServerName
     * @param string $arpCacheTimeout
     * @param string $ipAddressLeaseTime
     * @param string $renewalTime
     * @param string $rebindingTime
     */
    public function __construct(\StructType\XFkType $processNodeName = null, $uuid = null, \StructType\XFkType $newProcessNodeName = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $primaryTftpServerIpAddress = null, $secondaryTftpServerIpAddress = null, $bootstrapServerIpAddress = null, $domainName = null, $tftpServerName = null, $arpCacheTimeout = '0', $ipAddressLeaseTime = '0', $renewalTime = '0', $rebindingTime = '0')
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setUuid($uuid)
            ->setNewProcessNodeName($newProcessNodeName)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress)
            ->setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress)
            ->setBootstrapServerIpAddress($bootstrapServerIpAddress)
            ->setDomainName($domainName)
            ->setTftpServerName($tftpServerName)
            ->setArpCacheTimeout($arpCacheTimeout)
            ->setIpAddressLeaseTime($ipAddressLeaseTime)
            ->setRenewalTime($renewalTime)
            ->setRebindingTime($rebindingTime);
    }
    /**
     * Get processNodeName value
     * @return \StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProcessNodeName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcessNodeName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProcessNodeNameForChoiceConstraintsFromSetProcessNodeName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property processNodeName can\'t be set as the property %s is already set. Only one property must be set among these properties: processNodeName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set processNodeName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType $processNodeName
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setProcessNodeName(\StructType\XFkType $processNodeName = null)
    {
        // validation for constraint: choice(uuid, processNodeName)
        if ('' !== ($processNodeNameChoiceErrorMessage = self::validateProcessNodeNameForChoiceConstraintsFromSetProcessNodeName($processNodeName))) {
            throw new \InvalidArgumentException($processNodeNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'processNodeName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, processNodeName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newProcessNodeName value
     * @return \StructType\XFkType|null
     */
    public function getNewProcessNodeName()
    {
        return $this->newProcessNodeName;
    }
    /**
     * Set newProcessNodeName value
     * @param \StructType\XFkType $newProcessNodeName
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setNewProcessNodeName(\StructType\XFkType $newProcessNodeName = null)
    {
        $this->newProcessNodeName = $newProcessNodeName;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryDnsIpAddress) && !is_string($primaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryDnsIpAddress, true), gettype($primaryDnsIpAddress)), __LINE__);
        }
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryDnsIpAddress) && !is_string($secondaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryDnsIpAddress, true), gettype($secondaryDnsIpAddress)), __LINE__);
        }
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get primaryTftpServerIpAddress value
     * @return string|null
     */
    public function getPrimaryTftpServerIpAddress()
    {
        return $this->primaryTftpServerIpAddress;
    }
    /**
     * Set primaryTftpServerIpAddress value
     * @param string $primaryTftpServerIpAddress
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryTftpServerIpAddress) && !is_string($primaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryTftpServerIpAddress, true), gettype($primaryTftpServerIpAddress)), __LINE__);
        }
        $this->primaryTftpServerIpAddress = $primaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get secondaryTftpServerIpAddress value
     * @return string|null
     */
    public function getSecondaryTftpServerIpAddress()
    {
        return $this->secondaryTftpServerIpAddress;
    }
    /**
     * Set secondaryTftpServerIpAddress value
     * @param string $secondaryTftpServerIpAddress
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryTftpServerIpAddress) && !is_string($secondaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryTftpServerIpAddress, true), gettype($secondaryTftpServerIpAddress)), __LINE__);
        }
        $this->secondaryTftpServerIpAddress = $secondaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get bootstrapServerIpAddress value
     * @return string|null
     */
    public function getBootstrapServerIpAddress()
    {
        return $this->bootstrapServerIpAddress;
    }
    /**
     * Set bootstrapServerIpAddress value
     * @param string $bootstrapServerIpAddress
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setBootstrapServerIpAddress($bootstrapServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bootstrapServerIpAddress) && !is_string($bootstrapServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bootstrapServerIpAddress, true), gettype($bootstrapServerIpAddress)), __LINE__);
        }
        $this->bootstrapServerIpAddress = $bootstrapServerIpAddress;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get tftpServerName value
     * @return string|null
     */
    public function getTftpServerName()
    {
        return $this->tftpServerName;
    }
    /**
     * Set tftpServerName value
     * @param string $tftpServerName
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setTftpServerName($tftpServerName = null)
    {
        // validation for constraint: string
        if (!is_null($tftpServerName) && !is_string($tftpServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tftpServerName, true), gettype($tftpServerName)), __LINE__);
        }
        $this->tftpServerName = $tftpServerName;
        return $this;
    }
    /**
     * Get arpCacheTimeout value
     * @return string|null
     */
    public function getArpCacheTimeout()
    {
        return $this->arpCacheTimeout;
    }
    /**
     * Set arpCacheTimeout value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arpCacheTimeout
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setArpCacheTimeout($arpCacheTimeout = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($arpCacheTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($arpCacheTimeout) ? implode(', ', $arpCacheTimeout) : var_export($arpCacheTimeout, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->arpCacheTimeout = $arpCacheTimeout;
        return $this;
    }
    /**
     * Get ipAddressLeaseTime value
     * @return string|null
     */
    public function getIpAddressLeaseTime()
    {
        return $this->ipAddressLeaseTime;
    }
    /**
     * Set ipAddressLeaseTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressLeaseTime
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setIpAddressLeaseTime($ipAddressLeaseTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ipAddressLeaseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($ipAddressLeaseTime) ? implode(', ', $ipAddressLeaseTime) : var_export($ipAddressLeaseTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ipAddressLeaseTime = $ipAddressLeaseTime;
        return $this;
    }
    /**
     * Get renewalTime value
     * @return string|null
     */
    public function getRenewalTime()
    {
        return $this->renewalTime;
    }
    /**
     * Set renewalTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewalTime
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setRenewalTime($renewalTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($renewalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($renewalTime) ? implode(', ', $renewalTime) : var_export($renewalTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->renewalTime = $renewalTime;
        return $this;
    }
    /**
     * Get rebindingTime value
     * @return string|null
     */
    public function getRebindingTime()
    {
        return $this->rebindingTime;
    }
    /**
     * Set rebindingTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rebindingTime
     * @return \StructType\UpdateDhcpServerReq
     */
    public function setRebindingTime($rebindingTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($rebindingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($rebindingTime) ? implode(', ', $rebindingTime) : var_export($rebindingTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rebindingTime = $rebindingTime;
        return $this;
    }
}
