<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCcdHostedDNReq StructType
 * @subpackage Structs
 */
class UpdateCcdHostedDNReq extends APIRequest
{
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | hostedPattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostedPattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | hostedPattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newHostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newHostedPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The CcdHostedDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $CcdHostedDnGroup;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * Constructor method for UpdateCcdHostedDNReq
     * @uses UpdateCcdHostedDNReq::setHostedPattern()
     * @uses UpdateCcdHostedDNReq::setUuid()
     * @uses UpdateCcdHostedDNReq::setNewHostedPattern()
     * @uses UpdateCcdHostedDNReq::setDescription()
     * @uses UpdateCcdHostedDNReq::setCcdHostedDnGroup()
     * @uses UpdateCcdHostedDNReq::setPstnFailoverStripDigits()
     * @uses UpdateCcdHostedDNReq::setPstnFailoverPrependDigits()
     * @uses UpdateCcdHostedDNReq::setUsePstnFailover()
     * @param string $hostedPattern
     * @param string $uuid
     * @param string $newHostedPattern
     * @param string $description
     * @param \StructType\XFkType $ccdHostedDnGroup
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     */
    public function __construct($hostedPattern = null, $uuid = null, $newHostedPattern = null, $description = null, \StructType\XFkType $ccdHostedDnGroup = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = 'false')
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setUuid($uuid)
            ->setNewHostedPattern($newHostedPattern)
            ->setDescription($description)
            ->setCcdHostedDnGroup($ccdHostedDnGroup)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover);
    }
    /**
     * Get hostedPattern value
     * @return string
     */
    public function getHostedPattern()
    {
        return isset($this->hostedPattern) ? $this->hostedPattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHostedPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHostedPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHostedPatternForChoiceConstraintsFromSetHostedPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property hostedPattern can\'t be set as the property %s is already set. Only one property must be set among these properties: hostedPattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set hostedPattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $hostedPattern
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setHostedPattern($hostedPattern = null)
    {
        // validation for constraint: string
        if (!is_null($hostedPattern) && !is_string($hostedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostedPattern, true), gettype($hostedPattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, hostedPattern)
        if ('' !== ($hostedPatternChoiceErrorMessage = self::validateHostedPatternForChoiceConstraintsFromSetHostedPattern($hostedPattern))) {
            throw new \InvalidArgumentException($hostedPatternChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hostedPattern) && mb_strlen($hostedPattern) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($hostedPattern)), __LINE__);
        }
        if (is_null($hostedPattern) || (is_array($hostedPattern) && empty($hostedPattern))) {
            unset($this->hostedPattern);
        } else {
            $this->hostedPattern = $hostedPattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'hostedPattern',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, hostedPattern)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newHostedPattern value
     * @return string|null
     */
    public function getNewHostedPattern()
    {
        return $this->newHostedPattern;
    }
    /**
     * Set newHostedPattern value
     * @param string $newHostedPattern
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setNewHostedPattern($newHostedPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newHostedPattern) && !is_string($newHostedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newHostedPattern, true), gettype($newHostedPattern)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newHostedPattern) && mb_strlen($newHostedPattern) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newHostedPattern)), __LINE__);
        }
        $this->newHostedPattern = $newHostedPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get CcdHostedDnGroup value
     * @return \StructType\XFkType|null
     */
    public function getCcdHostedDnGroup()
    {
        return $this->CcdHostedDnGroup;
    }
    /**
     * Set CcdHostedDnGroup value
     * @param \StructType\XFkType $ccdHostedDnGroup
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setCcdHostedDnGroup(\StructType\XFkType $ccdHostedDnGroup = null)
    {
        $this->CcdHostedDnGroup = $ccdHostedDnGroup;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return isset($this->pstnFailoverStripDigits) ? $this->pstnFailoverStripDigits : null;
    }
    /**
     * Set pstnFailoverStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailoverStripDigits
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pstnFailoverStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($pstnFailoverStripDigits) ? implode(', ', $pstnFailoverStripDigits) : var_export($pstnFailoverStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($pstnFailoverStripDigits) || (is_array($pstnFailoverStripDigits) && empty($pstnFailoverStripDigits))) {
            unset($this->pstnFailoverStripDigits);
        } else {
            $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        }
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailoverPrependDigits) && !is_string($pstnFailoverPrependDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailoverPrependDigits, true), gettype($pstnFailoverPrependDigits)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($pstnFailoverPrependDigits) && mb_strlen($pstnFailoverPrependDigits) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($pstnFailoverPrependDigits)), __LINE__);
        }
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \StructType\UpdateCcdHostedDNReq
     */
    public function setUsePstnFailover($usePstnFailover = 'false')
    {
        // validation for constraint: string
        if (!is_null($usePstnFailover) && !is_string($usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePstnFailover, true), gettype($usePstnFailover)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($usePstnFailover) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($usePstnFailover, true)), __LINE__);
        }
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
}
