<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApplicationUserCapfProfileReq StructType
 * @subpackage Structs
 */
class UpdateApplicationUserCapfProfileReq extends APIRequest
{
    /**
     * The instanceId
     * Meta information extracted from the WSDL
     * - choice: uuid | instanceId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $instanceId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | instanceId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The operationCompletion
     * Meta information extracted from the WSDL
     * - documentation: Required format is YYYY:MM:DD:HH:SS. Read Only when certificateOperation is 'No Pending Operation'. Please provide the above format while adding a new device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $operationCompletion;
    /**
     * Constructor method for UpdateApplicationUserCapfProfileReq
     * @uses UpdateApplicationUserCapfProfileReq::setInstanceId()
     * @uses UpdateApplicationUserCapfProfileReq::setUuid()
     * @uses UpdateApplicationUserCapfProfileReq::setCertificateOperation()
     * @uses UpdateApplicationUserCapfProfileReq::setAuthenticationMode()
     * @uses UpdateApplicationUserCapfProfileReq::setAuthenticationString()
     * @uses UpdateApplicationUserCapfProfileReq::setKeySize()
     * @uses UpdateApplicationUserCapfProfileReq::setOperationCompletion()
     * @param string $instanceId
     * @param string $uuid
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $operationCompletion
     */
    public function __construct($instanceId = null, $uuid = null, $certificateOperation = 'No Pending Operation', $authenticationMode = 'By Null String', $authenticationString = null, $keySize = '1024', $operationCompletion = null)
    {
        $this
            ->setInstanceId($instanceId)
            ->setUuid($uuid)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setOperationCompletion($operationCompletion);
    }
    /**
     * Get instanceId value
     * @return string
     */
    public function getInstanceId()
    {
        return isset($this->instanceId) ? $this->instanceId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInstanceId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstanceId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInstanceIdForChoiceConstraintsFromSetInstanceId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property instanceId can\'t be set as the property %s is already set. Only one property must be set among these properties: instanceId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set instanceId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $instanceId
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceId, true), gettype($instanceId)), __LINE__);
        }
        // validation for constraint: choice(uuid, instanceId)
        if ('' !== ($instanceIdChoiceErrorMessage = self::validateInstanceIdForChoiceConstraintsFromSetInstanceId($instanceId))) {
            throw new \InvalidArgumentException($instanceIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($instanceId) || (is_array($instanceId) && empty($instanceId))) {
            unset($this->instanceId);
        } else {
            $this->instanceId = $instanceId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'instanceId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, instanceId)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \EnumType\XCertificateOperation::valueIsValid()
     * @uses \EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setCertificateOperation($certificateOperation = 'No Pending Operation')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCertificateOperation', is_array($certificateOperation) ? implode(', ', $certificateOperation) : var_export($certificateOperation, true), implode(', ', \EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XAuthenticationMode', is_array($authenticationMode) ? implode(', ', $authenticationMode) : var_export($authenticationMode, true), implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationString, true), gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XKeySize', is_array($keySize) ? implode(', ', $keySize) : var_export($keySize, true), implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationCompletion, true), gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
}
