<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for units StructType
 * Meta information extracted from the WSDL
 * - documentation: The units element is optional when a newVG224 is being added and can be added using updateVG224Gateway.
 * @subpackage Structs
 */
class Units extends AbstractStructBase
{
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unit[]
     */
    public $unit;
    /**
     * Constructor method for units
     * @uses Units::setUnit()
     * @param \StructType\Unit[] $unit
     */
    public function __construct(array $unit = array())
    {
        $this
            ->setUnit($unit);
    }
    /**
     * Get unit value
     * @return \StructType\Unit[]|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * This method is responsible for validating the values passed to the setUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitForArrayConstraintsFromSetUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsUnitItem) {
            // validation for constraint: itemType
            if (!$unitsUnitItem instanceof \StructType\Unit) {
                $invalidValues[] = is_object($unitsUnitItem) ? get_class($unitsUnitItem) : sprintf('%s(%s)', gettype($unitsUnitItem), var_export($unitsUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unit property can only contain items of type \StructType\Unit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unit value
     * @throws \InvalidArgumentException
     * @param \StructType\Unit[] $unit
     * @return \StructType\Units
     */
    public function setUnit(array $unit = array())
    {
        // validation for constraint: array
        if ('' !== ($unitArrayErrorMessage = self::validateUnitForArrayConstraintsFromSetUnit($unit))) {
            throw new \InvalidArgumentException($unitArrayErrorMessage, __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Add item to unit value
     * @throws \InvalidArgumentException
     * @param \StructType\Unit $item
     * @return \StructType\Units
     */
    public function addToUnit(\StructType\Unit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unit) {
            throw new \InvalidArgumentException(sprintf('The unit property can only contain items of type \StructType\Unit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unit[] = $item;
        return $this;
    }
}
