<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UGatewayEndpointDigitalT1 StructType
 * @subpackage Structs
 */
class UGatewayEndpointDigitalT1 extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The v150
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $v150;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The ports
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ports
     */
    public $ports;
    /**
     * The trunkSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkSelectionOrder;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csuParam;
    /**
     * The digitSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pcmType;
    /**
     * The fdlChannel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fdlChannel;
    /**
     * The yellowAlarm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $yellowAlarm;
    /**
     * The zeroSupression
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zeroSupression;
    /**
     * The smdiBasePort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smdiBasePort;
    /**
     * The handleDtmfPrecedenceSignals
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $handleDtmfPrecedenceSignals;
    /**
     * The encodeOutboundVoiceRouteClass
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $encodeOutboundVoiceRouteClass;
    /**
     * The routeClassSignalling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for UGatewayEndpointDigitalT1
     * @uses UGatewayEndpointDigitalT1::setIndex()
     * @uses UGatewayEndpointDigitalT1::setDescription()
     * @uses UGatewayEndpointDigitalT1::setCallingSearchSpaceName()
     * @uses UGatewayEndpointDigitalT1::setDevicePoolName()
     * @uses UGatewayEndpointDigitalT1::setCommonDeviceConfigName()
     * @uses UGatewayEndpointDigitalT1::setNetworkLocation()
     * @uses UGatewayEndpointDigitalT1::setLocationName()
     * @uses UGatewayEndpointDigitalT1::setMediaResourceListName()
     * @uses UGatewayEndpointDigitalT1::setAutomatedAlternateRoutingCssName()
     * @uses UGatewayEndpointDigitalT1::setAarNeighborhoodName()
     * @uses UGatewayEndpointDigitalT1::setLoadInformation()
     * @uses UGatewayEndpointDigitalT1::setVendorConfig()
     * @uses UGatewayEndpointDigitalT1::setTraceFlag()
     * @uses UGatewayEndpointDigitalT1::setMlppDomainId()
     * @uses UGatewayEndpointDigitalT1::setMlppIndicationStatus()
     * @uses UGatewayEndpointDigitalT1::setPreemption()
     * @uses UGatewayEndpointDigitalT1::setUseTrustedRelayPoint()
     * @uses UGatewayEndpointDigitalT1::setRetryVideoCallAsAudio()
     * @uses UGatewayEndpointDigitalT1::setCgpnTransformationCssName()
     * @uses UGatewayEndpointDigitalT1::setUseDevicePoolCgpnTransformCss()
     * @uses UGatewayEndpointDigitalT1::setGeoLocationName()
     * @uses UGatewayEndpointDigitalT1::setSendGeoLocation()
     * @uses UGatewayEndpointDigitalT1::setCdpnTransformationCssName()
     * @uses UGatewayEndpointDigitalT1::setUseDevicePoolCdpnTransformCss()
     * @uses UGatewayEndpointDigitalT1::setV150()
     * @uses UGatewayEndpointDigitalT1::setGeoLocationFilterName()
     * @uses UGatewayEndpointDigitalT1::setPorts()
     * @uses UGatewayEndpointDigitalT1::setTrunkSelectionOrder()
     * @uses UGatewayEndpointDigitalT1::setClockReference()
     * @uses UGatewayEndpointDigitalT1::setCsuParam()
     * @uses UGatewayEndpointDigitalT1::setDigitSending()
     * @uses UGatewayEndpointDigitalT1::setPcmType()
     * @uses UGatewayEndpointDigitalT1::setFdlChannel()
     * @uses UGatewayEndpointDigitalT1::setYellowAlarm()
     * @uses UGatewayEndpointDigitalT1::setZeroSupression()
     * @uses UGatewayEndpointDigitalT1::setSmdiBasePort()
     * @uses UGatewayEndpointDigitalT1::setHandleDtmfPrecedenceSignals()
     * @uses UGatewayEndpointDigitalT1::setEncodeOutboundVoiceRouteClass()
     * @uses UGatewayEndpointDigitalT1::setRouteClassSignalling()
     * @uses UGatewayEndpointDigitalT1::setPstnAccess()
     * @uses UGatewayEndpointDigitalT1::setImeE164TransformationName()
     * @uses UGatewayEndpointDigitalT1::setConfidentialAccess()
     * @uses UGatewayEndpointDigitalT1::setCtiid()
     * @uses UGatewayEndpointDigitalT1::setUuid()
     * @param string $index
     * @param string $description
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mediaResourceListName
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XLoadInformation $loadInformation
     * @param \StructType\XVendorConfig $vendorConfig
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param string $sendGeoLocation
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $v150
     * @param \StructType\XFkType $geoLocationFilterName
     * @param \StructType\Ports $ports
     * @param string $trunkSelectionOrder
     * @param string $clockReference
     * @param string $csuParam
     * @param string $digitSending
     * @param string $pcmType
     * @param string $fdlChannel
     * @param string $yellowAlarm
     * @param string $zeroSupression
     * @param string $smdiBasePort
     * @param string $handleDtmfPrecedenceSignals
     * @param string $encodeOutboundVoiceRouteClass
     * @param string $routeClassSignalling
     * @param string $pstnAccess
     * @param \StructType\XFkType $imeE164TransformationName
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $description = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, $networkLocation = null, \StructType\XFkType $locationName = null, \StructType\XFkType $mediaResourceListName = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XLoadInformation $loadInformation = null, \StructType\XVendorConfig $vendorConfig = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \StructType\XFkType $geoLocationName = null, $sendGeoLocation = null, \StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $v150 = null, \StructType\XFkType $geoLocationFilterName = null, \StructType\Ports $ports = null, $trunkSelectionOrder = null, $clockReference = null, $csuParam = null, $digitSending = null, $pcmType = null, $fdlChannel = null, $yellowAlarm = null, $zeroSupression = null, $smdiBasePort = null, $handleDtmfPrecedenceSignals = null, $encodeOutboundVoiceRouteClass = null, $routeClassSignalling = null, $pstnAccess = null, \StructType\XFkType $imeE164TransformationName = null, \StructType\ConfidentialAccess $confidentialAccess = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setV150($v150)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setPorts($ports)
            ->setTrunkSelectionOrder($trunkSelectionOrder)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDigitSending($digitSending)
            ->setPcmType($pcmType)
            ->setFdlChannel($fdlChannel)
            ->setYellowAlarm($yellowAlarm)
            ->setZeroSupression($zeroSupression)
            ->setSmdiBasePort($smdiBasePort)
            ->setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals)
            ->setEncodeOutboundVoiceRouteClass($encodeOutboundVoiceRouteClass)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \EnumType\XNetworkLocation::valueIsValid()
     * @uses \EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceFlag, true), gettype($traceFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($traceFlag, true)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppDomainId, true), gettype($mlppDomainId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mlppDomainId) && mb_strlen($mlppDomainId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryVideoCallAsAudio, true), gettype($retryVideoCallAsAudio)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendGeoLocation, true), gettype($sendGeoLocation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendGeoLocation, true)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCdpnTransformCss, true), gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get v150 value
     * @return string|null
     */
    public function getV150()
    {
        return $this->v150;
    }
    /**
     * Set v150 value
     * @param string $v150
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setV150($v150 = null)
    {
        // validation for constraint: string
        if (!is_null($v150) && !is_string($v150)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v150, true), gettype($v150)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($v150) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $v150)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($v150, true)), __LINE__);
        }
        $this->v150 = $v150;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get ports value
     * @return \StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \StructType\Ports $ports
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setPorts(\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get trunkSelectionOrder value
     * @return string|null
     */
    public function getTrunkSelectionOrder()
    {
        return $this->trunkSelectionOrder;
    }
    /**
     * Set trunkSelectionOrder value
     * @uses \EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkSelectionOrder
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setTrunkSelectionOrder($trunkSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkSelectionOrder::valueIsValid($trunkSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunkSelectionOrder', is_array($trunkSelectionOrder) ? implode(', ', $trunkSelectionOrder) : var_export($trunkSelectionOrder, true), implode(', ', \EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->trunkSelectionOrder = $trunkSelectionOrder;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses \EnumType\XClockReference::valueIsValid()
     * @uses \EnumType\XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XClockReference', is_array($clockReference) ? implode(', ', $clockReference) : var_export($clockReference, true), implode(', ', \EnumType\XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses \EnumType\XCSUParam::valueIsValid()
     * @uses \EnumType\XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCSUParam', is_array($csuParam) ? implode(', ', $csuParam) : var_export($csuParam, true), implode(', ', \EnumType\XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses \EnumType\XDigitSending::valueIsValid()
     * @uses \EnumType\XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setDigitSending($digitSending = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDigitSending', is_array($digitSending) ? implode(', ', $digitSending) : var_export($digitSending, true), implode(', ', \EnumType\XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses \EnumType\XEncode::valueIsValid()
     * @uses \EnumType\XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XEncode', is_array($pcmType) ? implode(', ', $pcmType) : var_export($pcmType, true), implode(', ', \EnumType\XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get fdlChannel value
     * @return string|null
     */
    public function getFdlChannel()
    {
        return $this->fdlChannel;
    }
    /**
     * Set fdlChannel value
     * @uses \EnumType\XFDLChannel::valueIsValid()
     * @uses \EnumType\XFDLChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fdlChannel
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setFdlChannel($fdlChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XFDLChannel::valueIsValid($fdlChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XFDLChannel', is_array($fdlChannel) ? implode(', ', $fdlChannel) : var_export($fdlChannel, true), implode(', ', \EnumType\XFDLChannel::getValidValues())), __LINE__);
        }
        $this->fdlChannel = $fdlChannel;
        return $this;
    }
    /**
     * Get yellowAlarm value
     * @return string|null
     */
    public function getYellowAlarm()
    {
        return $this->yellowAlarm;
    }
    /**
     * Set yellowAlarm value
     * @uses \EnumType\XYellowAlarm::valueIsValid()
     * @uses \EnumType\XYellowAlarm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yellowAlarm
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setYellowAlarm($yellowAlarm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XYellowAlarm::valueIsValid($yellowAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XYellowAlarm', is_array($yellowAlarm) ? implode(', ', $yellowAlarm) : var_export($yellowAlarm, true), implode(', ', \EnumType\XYellowAlarm::getValidValues())), __LINE__);
        }
        $this->yellowAlarm = $yellowAlarm;
        return $this;
    }
    /**
     * Get zeroSupression value
     * @return string|null
     */
    public function getZeroSupression()
    {
        return $this->zeroSupression;
    }
    /**
     * Set zeroSupression value
     * @uses \EnumType\XZeroSuppression::valueIsValid()
     * @uses \EnumType\XZeroSuppression::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zeroSupression
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setZeroSupression($zeroSupression = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZeroSuppression::valueIsValid($zeroSupression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZeroSuppression', is_array($zeroSupression) ? implode(', ', $zeroSupression) : var_export($zeroSupression, true), implode(', ', \EnumType\XZeroSuppression::getValidValues())), __LINE__);
        }
        $this->zeroSupression = $zeroSupression;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string|null
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smdiBasePort
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setSmdiBasePort($smdiBasePort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($smdiBasePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($smdiBasePort) ? implode(', ', $smdiBasePort) : var_export($smdiBasePort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get handleDtmfPrecedenceSignals value
     * @return string|null
     */
    public function getHandleDtmfPrecedenceSignals()
    {
        return $this->handleDtmfPrecedenceSignals;
    }
    /**
     * Set handleDtmfPrecedenceSignals value
     * @param string $handleDtmfPrecedenceSignals
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals = null)
    {
        // validation for constraint: string
        if (!is_null($handleDtmfPrecedenceSignals) && !is_string($handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleDtmfPrecedenceSignals, true), gettype($handleDtmfPrecedenceSignals)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($handleDtmfPrecedenceSignals) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($handleDtmfPrecedenceSignals, true)), __LINE__);
        }
        $this->handleDtmfPrecedenceSignals = $handleDtmfPrecedenceSignals;
        return $this;
    }
    /**
     * Get encodeOutboundVoiceRouteClass value
     * @return string|null
     */
    public function getEncodeOutboundVoiceRouteClass()
    {
        return $this->encodeOutboundVoiceRouteClass;
    }
    /**
     * Set encodeOutboundVoiceRouteClass value
     * @param string $encodeOutboundVoiceRouteClass
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setEncodeOutboundVoiceRouteClass($encodeOutboundVoiceRouteClass = null)
    {
        // validation for constraint: string
        if (!is_null($encodeOutboundVoiceRouteClass) && !is_string($encodeOutboundVoiceRouteClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encodeOutboundVoiceRouteClass, true), gettype($encodeOutboundVoiceRouteClass)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($encodeOutboundVoiceRouteClass) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $encodeOutboundVoiceRouteClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($encodeOutboundVoiceRouteClass, true)), __LINE__);
        }
        $this->encodeOutboundVoiceRouteClass = $encodeOutboundVoiceRouteClass;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClassSignalling
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setRouteClassSignalling($routeClassSignalling = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($routeClassSignalling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($routeClassSignalling) ? implode(', ', $routeClassSignalling) : var_export($routeClassSignalling, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnAccess, true), gettype($pstnAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pstnAccess, true)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \StructType\XFkType $imeE164TransformationName
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setImeE164TransformationName(\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UGatewayEndpointDigitalT1
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
