<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subunit StructType
 * @subpackage Structs
 */
class Subunit extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $index;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The beginPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $beginPort;
    /**
     * Constructor method for subunit
     * @uses Subunit::setIndex()
     * @uses Subunit::setProduct()
     * @uses Subunit::setBeginPort()
     * @param string $index
     * @param string $product
     * @param string $beginPort
     */
    public function __construct($index = null, $product = null, $beginPort = null)
    {
        $this
            ->setIndex($index)
            ->setProduct($product)
            ->setBeginPort($beginPort);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\Subunit
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XMGCPVic::valueIsValid()
     * @uses \EnumType\XMGCPVic::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\Subunit
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMGCPVic::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMGCPVic', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XMGCPVic::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get beginPort value
     * @return string|null
     */
    public function getBeginPort()
    {
        return $this->beginPort;
    }
    /**
     * Set beginPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $beginPort
     * @return \StructType\Subunit
     */
    public function setBeginPort($beginPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($beginPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($beginPort) ? implode(', ', $beginPort) : var_export($beginPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->beginPort = $beginPort;
        return $this;
    }
}
