<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removePatterns StructType
 * @subpackage Structs
 */
class RemovePatterns extends XCommonMembersExtension
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XPatternMember[]
     */
    public $pattern;
    /**
     * Constructor method for removePatterns
     * @uses RemovePatterns::setPattern()
     * @param \StructType\XPatternMember[] $pattern
     */
    public function __construct(array $pattern = array())
    {
        $this
            ->setPattern($pattern);
    }
    /**
     * Get pattern value
     * @return \StructType\XPatternMember[]
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * This method is responsible for validating the values passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePatternForArrayConstraintsFromSetPattern(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $removePatternsPatternItem) {
            // validation for constraint: itemType
            if (!$removePatternsPatternItem instanceof \StructType\XPatternMember) {
                $invalidValues[] = is_object($removePatternsPatternItem) ? get_class($removePatternsPatternItem) : sprintf('%s(%s)', gettype($removePatternsPatternItem), var_export($removePatternsPatternItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pattern property can only contain items of type \StructType\XPatternMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pattern value
     * @throws \InvalidArgumentException
     * @param \StructType\XPatternMember[] $pattern
     * @return \StructType\RemovePatterns
     */
    public function setPattern(array $pattern = array())
    {
        // validation for constraint: array
        if ('' !== ($patternArrayErrorMessage = self::validatePatternForArrayConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternArrayErrorMessage, __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Add item to pattern value
     * @throws \InvalidArgumentException
     * @param \StructType\XPatternMember $item
     * @return \StructType\RemovePatterns
     */
    public function addToPattern(\StructType\XPatternMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPatternMember) {
            throw new \InvalidArgumentException(sprintf('The pattern property can only contain items of type \StructType\XPatternMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pattern[] = $item;
        return $this;
    }
}
