<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUserProfileProvision StructType
 * @subpackage Structs
 */
class RUserProfileProvision extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The deskPhones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $deskPhones;
    /**
     * The mobileDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mobileDevices;
    /**
     * The profile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $profile;
    /**
     * The universalLineTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $universalLineTemplate;
    /**
     * The allowProvision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowProvision;
    /**
     * The limitProvision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $limitProvision;
    /**
     * The defaultUserProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $defaultUserProfile;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUserProfileProvision
     * @uses RUserProfileProvision::setName()
     * @uses RUserProfileProvision::setDescription()
     * @uses RUserProfileProvision::setDeskPhones()
     * @uses RUserProfileProvision::setMobileDevices()
     * @uses RUserProfileProvision::setProfile()
     * @uses RUserProfileProvision::setUniversalLineTemplate()
     * @uses RUserProfileProvision::setAllowProvision()
     * @uses RUserProfileProvision::setLimitProvision()
     * @uses RUserProfileProvision::setDefaultUserProfile()
     * @uses RUserProfileProvision::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $deskPhones
     * @param \StructType\XFkType $mobileDevices
     * @param \StructType\XFkType $profile
     * @param \StructType\XFkType $universalLineTemplate
     * @param string $allowProvision
     * @param string $limitProvision
     * @param \StructType\XFkType $defaultUserProfile
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $deskPhones = null, \StructType\XFkType $mobileDevices = null, \StructType\XFkType $profile = null, \StructType\XFkType $universalLineTemplate = null, $allowProvision = null, $limitProvision = null, \StructType\XFkType $defaultUserProfile = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDeskPhones($deskPhones)
            ->setMobileDevices($mobileDevices)
            ->setProfile($profile)
            ->setUniversalLineTemplate($universalLineTemplate)
            ->setAllowProvision($allowProvision)
            ->setLimitProvision($limitProvision)
            ->setDefaultUserProfile($defaultUserProfile)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RUserProfileProvision
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RUserProfileProvision
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deskPhones value
     * @return \StructType\XFkType|null
     */
    public function getDeskPhones()
    {
        return $this->deskPhones;
    }
    /**
     * Set deskPhones value
     * @param \StructType\XFkType $deskPhones
     * @return \StructType\RUserProfileProvision
     */
    public function setDeskPhones(\StructType\XFkType $deskPhones = null)
    {
        $this->deskPhones = $deskPhones;
        return $this;
    }
    /**
     * Get mobileDevices value
     * @return \StructType\XFkType|null
     */
    public function getMobileDevices()
    {
        return $this->mobileDevices;
    }
    /**
     * Set mobileDevices value
     * @param \StructType\XFkType $mobileDevices
     * @return \StructType\RUserProfileProvision
     */
    public function setMobileDevices(\StructType\XFkType $mobileDevices = null)
    {
        $this->mobileDevices = $mobileDevices;
        return $this;
    }
    /**
     * Get profile value
     * @return \StructType\XFkType|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param \StructType\XFkType $profile
     * @return \StructType\RUserProfileProvision
     */
    public function setProfile(\StructType\XFkType $profile = null)
    {
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get universalLineTemplate value
     * @return \StructType\XFkType|null
     */
    public function getUniversalLineTemplate()
    {
        return $this->universalLineTemplate;
    }
    /**
     * Set universalLineTemplate value
     * @param \StructType\XFkType $universalLineTemplate
     * @return \StructType\RUserProfileProvision
     */
    public function setUniversalLineTemplate(\StructType\XFkType $universalLineTemplate = null)
    {
        $this->universalLineTemplate = $universalLineTemplate;
        return $this;
    }
    /**
     * Get allowProvision value
     * @return string|null
     */
    public function getAllowProvision()
    {
        return $this->allowProvision;
    }
    /**
     * Set allowProvision value
     * @param string $allowProvision
     * @return \StructType\RUserProfileProvision
     */
    public function setAllowProvision($allowProvision = null)
    {
        // validation for constraint: string
        if (!is_null($allowProvision) && !is_string($allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowProvision, true), gettype($allowProvision)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowProvision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowProvision, true)), __LINE__);
        }
        $this->allowProvision = $allowProvision;
        return $this;
    }
    /**
     * Get limitProvision value
     * @return string|null
     */
    public function getLimitProvision()
    {
        return $this->limitProvision;
    }
    /**
     * Set limitProvision value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitProvision
     * @return \StructType\RUserProfileProvision
     */
    public function setLimitProvision($limitProvision = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($limitProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($limitProvision) ? implode(', ', $limitProvision) : var_export($limitProvision, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->limitProvision = $limitProvision;
        return $this;
    }
    /**
     * Get defaultUserProfile value
     * @return \StructType\XFkType|null
     */
    public function getDefaultUserProfile()
    {
        return $this->defaultUserProfile;
    }
    /**
     * Set defaultUserProfile value
     * @param \StructType\XFkType $defaultUserProfile
     * @return \StructType\RUserProfileProvision
     */
    public function setDefaultUserProfile(\StructType\XFkType $defaultUserProfile = null)
    {
        $this->defaultUserProfile = $defaultUserProfile;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RUserProfileProvision
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
