<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTvsCertificateService StructType
 * @subpackage Structs
 */
class RTvsCertificateService extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTvsCertificateService
     * @uses RTvsCertificateService::setServiceName()
     * @uses RTvsCertificateService::setUuid()
     * @param string $serviceName
     * @param string $uuid
     */
    public function __construct($serviceName = null, $uuid = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setUuid($uuid);
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @uses \EnumType\XCertificateService::valueIsValid()
     * @uses \EnumType\XCertificateService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceName
     * @return \StructType\RTvsCertificateService
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateService::valueIsValid($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCertificateService', is_array($serviceName) ? implode(', ', $serviceName) : var_export($serviceName, true), implode(', ', \EnumType\XCertificateService::getValidValues())), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RTvsCertificateService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
