<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTimeScheduleTimePeriod StructType
 * @subpackage Structs
 */
class RTimeScheduleTimePeriod extends AbstractStructBase
{
    /**
     * The timePeriodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $timePeriodName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTimeScheduleTimePeriod
     * @uses RTimeScheduleTimePeriod::setTimePeriodName()
     * @uses RTimeScheduleTimePeriod::setUuid()
     * @param \StructType\XFkType $timePeriodName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $timePeriodName = null, $uuid = null)
    {
        $this
            ->setTimePeriodName($timePeriodName)
            ->setUuid($uuid);
    }
    /**
     * Get timePeriodName value
     * @return \StructType\XFkType|null
     */
    public function getTimePeriodName()
    {
        return $this->timePeriodName;
    }
    /**
     * Set timePeriodName value
     * @param \StructType\XFkType $timePeriodName
     * @return \StructType\RTimeScheduleTimePeriod
     */
    public function setTimePeriodName(\StructType\XFkType $timePeriodName = null)
    {
        $this->timePeriodName = $timePeriodName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RTimeScheduleTimePeriod
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
