<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTimePeriod StructType
 * @subpackage Structs
 */
class RTimePeriod extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta information extracted from the WSDL
     * - documentation: TimePeriod cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Period can be published.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The todOwnerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The dayOfMonthEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTimePeriod
     * @uses RTimePeriod::setName()
     * @uses RTimePeriod::setStartTime()
     * @uses RTimePeriod::setEndTime()
     * @uses RTimePeriod::setStartDay()
     * @uses RTimePeriod::setEndDay()
     * @uses RTimePeriod::setMonthOfYear()
     * @uses RTimePeriod::setDayOfMonth()
     * @uses RTimePeriod::setDescription()
     * @uses RTimePeriod::setIsPublished()
     * @uses RTimePeriod::setTodOwnerIdName()
     * @uses RTimePeriod::setDayOfMonthEnd()
     * @uses RTimePeriod::setMonthOfYearEnd()
     * @uses RTimePeriod::setUuid()
     * @param string $name
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $isPublished
     * @param \StructType\XFkType $todOwnerIdName
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     * @param string $uuid
     */
    public function __construct($name = null, $startTime = null, $endTime = null, $startDay = null, $endDay = null, $monthOfYear = null, $dayOfMonth = null, $description = null, $isPublished = null, \StructType\XFkType $todOwnerIdName = null, $dayOfMonthEnd = null, $monthOfYearEnd = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RTimePeriod
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startTime
     * @return \StructType\RTimePeriod
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeOfDay', is_array($startTime) ? implode(', ', $startTime) : var_export($startTime, true), implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTime
     * @return \StructType\RTimePeriod
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeOfDay', is_array($endTime) ? implode(', ', $endTime) : var_export($endTime, true), implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \StructType\RTimePeriod
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDayOfWeek', is_array($startDay) ? implode(', ', $startDay) : var_export($startDay, true), implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endDay
     * @return \StructType\RTimePeriod
     */
    public function setEndDay($endDay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($endDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDayOfWeek', is_array($endDay) ? implode(', ', $endDay) : var_export($endDay, true), implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYear
     * @return \StructType\RTimePeriod
     */
    public function setMonthOfYear($monthOfYear = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMonthOfYear', is_array($monthOfYear) ? implode(', ', $monthOfYear) : var_export($monthOfYear, true), implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonth
     * @return \StructType\RTimePeriod
     */
    public function setDayOfMonth($dayOfMonth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dayOfMonth) ? implode(', ', $dayOfMonth) : var_export($dayOfMonth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RTimePeriod
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \StructType\RTimePeriod
     */
    public function setIsPublished($isPublished = null)
    {
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPublished, true), gettype($isPublished)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPublished, true)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * @return \StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return $this->todOwnerIdName;
    }
    /**
     * Set todOwnerIdName value
     * @param \StructType\XFkType $todOwnerIdName
     * @return \StructType\RTimePeriod
     */
    public function setTodOwnerIdName(\StructType\XFkType $todOwnerIdName = null)
    {
        $this->todOwnerIdName = $todOwnerIdName;
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonthEnd
     * @return \StructType\RTimePeriod
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonthEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dayOfMonthEnd) ? implode(', ', $dayOfMonthEnd) : var_export($dayOfMonthEnd, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYearEnd
     * @return \StructType\RTimePeriod
     */
    public function setMonthOfYearEnd($monthOfYearEnd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMonthOfYear', is_array($monthOfYearEnd) ? implode(', ', $monthOfYearEnd) : var_export($monthOfYearEnd, true), implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RTimePeriod
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
