<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSdpTransparencyProfile StructType
 * @subpackage Structs
 */
class RSdpTransparencyProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The attributeSet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttributeSet[]
     */
    public $attributeSet;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSdpTransparencyProfile
     * @uses RSdpTransparencyProfile::setName()
     * @uses RSdpTransparencyProfile::setDescription()
     * @uses RSdpTransparencyProfile::setAttributeSet()
     * @uses RSdpTransparencyProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\AttributeSet[] $attributeSet
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, array $attributeSet = array(), $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAttributeSet($attributeSet)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RSdpTransparencyProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RSdpTransparencyProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get attributeSet value
     * @return \StructType\AttributeSet[]|null
     */
    public function getAttributeSet()
    {
        return $this->attributeSet;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributeSet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributeSet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeSetForArrayConstraintsFromSetAttributeSet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rSdpTransparencyProfileAttributeSetItem) {
            // validation for constraint: itemType
            if (!$rSdpTransparencyProfileAttributeSetItem instanceof \StructType\AttributeSet) {
                $invalidValues[] = is_object($rSdpTransparencyProfileAttributeSetItem) ? get_class($rSdpTransparencyProfileAttributeSetItem) : sprintf('%s(%s)', gettype($rSdpTransparencyProfileAttributeSetItem), var_export($rSdpTransparencyProfileAttributeSetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attributeSet property can only contain items of type \StructType\AttributeSet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attributeSet value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeSet[] $attributeSet
     * @return \StructType\RSdpTransparencyProfile
     */
    public function setAttributeSet(array $attributeSet = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeSetArrayErrorMessage = self::validateAttributeSetForArrayConstraintsFromSetAttributeSet($attributeSet))) {
            throw new \InvalidArgumentException($attributeSetArrayErrorMessage, __LINE__);
        }
        $this->attributeSet = $attributeSet;
        return $this;
    }
    /**
     * Add item to attributeSet value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeSet $item
     * @return \StructType\RSdpTransparencyProfile
     */
    public function addToAttributeSet(\StructType\AttributeSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributeSet) {
            throw new \InvalidArgumentException(sprintf('The attributeSet property can only contain items of type \StructType\AttributeSet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attributeSet[] = $item;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RSdpTransparencyProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
