<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPresenceGroupMember StructType
 * @subpackage Structs
 */
class RPresenceGroupMember extends AbstractStructBase
{
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscriptionPermission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriptionPermission;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPresenceGroupMember
     * @uses RPresenceGroupMember::setPresenceGroupName()
     * @uses RPresenceGroupMember::setSubscriptionPermission()
     * @uses RPresenceGroupMember::setUuid()
     * @param \StructType\XFkType $presenceGroupName
     * @param string $subscriptionPermission
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $presenceGroupName = null, $subscriptionPermission = null, $uuid = null)
    {
        $this
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscriptionPermission($subscriptionPermission)
            ->setUuid($uuid);
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\RPresenceGroupMember
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscriptionPermission value
     * @return string|null
     */
    public function getSubscriptionPermission()
    {
        return $this->subscriptionPermission;
    }
    /**
     * Set subscriptionPermission value
     * @uses \EnumType\XMatrixValue::valueIsValid()
     * @uses \EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPermission
     * @return \StructType\RPresenceGroupMember
     */
    public function setSubscriptionPermission($subscriptionPermission = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMatrixValue::valueIsValid($subscriptionPermission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMatrixValue', is_array($subscriptionPermission) ? implode(', ', $subscriptionPermission) : var_export($subscriptionPermission, true), implode(', ', \EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->subscriptionPermission = $subscriptionPermission;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RPresenceGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
