<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPageLayoutPreferences StructType
 * @subpackage Structs
 */
class RPageLayoutPreferences extends AbstractStructBase
{
    /**
     * The pageName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageName;
    /**
     * The pageSections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PageSections
     */
    public $pageSections;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPageLayoutPreferences
     * @uses RPageLayoutPreferences::setPageName()
     * @uses RPageLayoutPreferences::setPageSections()
     * @uses RPageLayoutPreferences::setUuid()
     * @param string $pageName
     * @param \StructType\PageSections $pageSections
     * @param string $uuid
     */
    public function __construct($pageName = null, \StructType\PageSections $pageSections = null, $uuid = null)
    {
        $this
            ->setPageName($pageName)
            ->setPageSections($pageSections)
            ->setUuid($uuid);
    }
    /**
     * Get pageName value
     * @return string|null
     */
    public function getPageName()
    {
        return $this->pageName;
    }
    /**
     * Set pageName value
     * @param string $pageName
     * @return \StructType\RPageLayoutPreferences
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageName, true), gettype($pageName)), __LINE__);
        }
        $this->pageName = $pageName;
        return $this;
    }
    /**
     * Get pageSections value
     * @return \StructType\PageSections|null
     */
    public function getPageSections()
    {
        return $this->pageSections;
    }
    /**
     * Set pageSections value
     * @param \StructType\PageSections $pageSections
     * @return \StructType\RPageLayoutPreferences
     */
    public function setPageSections(\StructType\PageSections $pageSections = null)
    {
        $this->pageSections = $pageSections;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RPageLayoutPreferences
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
