<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMtp StructType
 * @subpackage Structs
 */
class RMtp extends AbstractStructBase
{
    /**
     * The mtpType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The trustedRelayPoint
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trustedRelayPoint;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMtp
     * @uses RMtp::setMtpType()
     * @uses RMtp::setName()
     * @uses RMtp::setDescription()
     * @uses RMtp::setDevicePoolName()
     * @uses RMtp::setTrustedRelayPoint()
     * @uses RMtp::setUuid()
     * @param string $mtpType
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $devicePoolName
     * @param string $trustedRelayPoint
     * @param string $uuid
     */
    public function __construct($mtpType = null, $name = null, $description = null, \StructType\XFkType $devicePoolName = null, $trustedRelayPoint = null, $uuid = null)
    {
        $this
            ->setMtpType($mtpType)
            ->setName($name)
            ->setDescription($description)
            ->setDevicePoolName($devicePoolName)
            ->setTrustedRelayPoint($trustedRelayPoint)
            ->setUuid($uuid);
    }
    /**
     * Get mtpType value
     * @return string|null
     */
    public function getMtpType()
    {
        return $this->mtpType;
    }
    /**
     * Set mtpType value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpType
     * @return \StructType\RMtp
     */
    public function setMtpType($mtpType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($mtpType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProduct', is_array($mtpType) ? implode(', ', $mtpType) : var_export($mtpType, true), implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->mtpType = $mtpType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RMtp
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RMtp
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\RMtp
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get trustedRelayPoint value
     * @return string|null
     */
    public function getTrustedRelayPoint()
    {
        return $this->trustedRelayPoint;
    }
    /**
     * Set trustedRelayPoint value
     * @param string $trustedRelayPoint
     * @return \StructType\RMtp
     */
    public function setTrustedRelayPoint($trustedRelayPoint = null)
    {
        // validation for constraint: string
        if (!is_null($trustedRelayPoint) && !is_string($trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trustedRelayPoint, true), gettype($trustedRelayPoint)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($trustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($trustedRelayPoint, true)), __LINE__);
        }
        $this->trustedRelayPoint = $trustedRelayPoint;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RMtp
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
