<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeLearnedRoutes StructType
 * @subpackage Structs
 */
class RImeLearnedRoutes extends AbstractStructBase
{
    /**
     * The e164Did
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $e164Did;
    /**
     * The domain
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The signaling
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 1024
     * - minOccurs: 0
     * @var string
     */
    public $signaling;
    /**
     * The learnedOn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $learnedOn;
    /**
     * The expiresOn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $expiresOn;
    /**
     * The adminEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $adminEnabled;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeLearnedRoutes
     * @uses RImeLearnedRoutes::setE164Did()
     * @uses RImeLearnedRoutes::setDomain()
     * @uses RImeLearnedRoutes::setSignaling()
     * @uses RImeLearnedRoutes::setLearnedOn()
     * @uses RImeLearnedRoutes::setExpiresOn()
     * @uses RImeLearnedRoutes::setAdminEnabled()
     * @uses RImeLearnedRoutes::setUuid()
     * @param string $e164Did
     * @param string $domain
     * @param string $signaling
     * @param string $learnedOn
     * @param string $expiresOn
     * @param string $adminEnabled
     * @param string $uuid
     */
    public function __construct($e164Did = null, $domain = null, $signaling = null, $learnedOn = null, $expiresOn = null, $adminEnabled = 'false', $uuid = null)
    {
        $this
            ->setE164Did($e164Did)
            ->setDomain($domain)
            ->setSignaling($signaling)
            ->setLearnedOn($learnedOn)
            ->setExpiresOn($expiresOn)
            ->setAdminEnabled($adminEnabled)
            ->setUuid($uuid);
    }
    /**
     * Get e164Did value
     * @return string|null
     */
    public function getE164Did()
    {
        return $this->e164Did;
    }
    /**
     * Set e164Did value
     * @param string $e164Did
     * @return \StructType\RImeLearnedRoutes
     */
    public function setE164Did($e164Did = null)
    {
        // validation for constraint: string
        if (!is_null($e164Did) && !is_string($e164Did)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Did, true), gettype($e164Did)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($e164Did) && mb_strlen($e164Did) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($e164Did)), __LINE__);
        }
        $this->e164Did = $e164Did;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\RImeLearnedRoutes
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($domain) && mb_strlen($domain) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get signaling value
     * @return string|null
     */
    public function getSignaling()
    {
        return $this->signaling;
    }
    /**
     * Set signaling value
     * @param string $signaling
     * @return \StructType\RImeLearnedRoutes
     */
    public function setSignaling($signaling = null)
    {
        // validation for constraint: string
        if (!is_null($signaling) && !is_string($signaling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signaling, true), gettype($signaling)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($signaling) && mb_strlen($signaling) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($signaling)), __LINE__);
        }
        $this->signaling = $signaling;
        return $this;
    }
    /**
     * Get learnedOn value
     * @return string|null
     */
    public function getLearnedOn()
    {
        return $this->learnedOn;
    }
    /**
     * Set learnedOn value
     * @param string $learnedOn
     * @return \StructType\RImeLearnedRoutes
     */
    public function setLearnedOn($learnedOn = null)
    {
        // validation for constraint: string
        if (!is_null($learnedOn) && !is_string($learnedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedOn, true), gettype($learnedOn)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($learnedOn) && mb_strlen($learnedOn) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($learnedOn)), __LINE__);
        }
        $this->learnedOn = $learnedOn;
        return $this;
    }
    /**
     * Get expiresOn value
     * @return string|null
     */
    public function getExpiresOn()
    {
        return $this->expiresOn;
    }
    /**
     * Set expiresOn value
     * @param string $expiresOn
     * @return \StructType\RImeLearnedRoutes
     */
    public function setExpiresOn($expiresOn = null)
    {
        // validation for constraint: string
        if (!is_null($expiresOn) && !is_string($expiresOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiresOn, true), gettype($expiresOn)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($expiresOn) && mb_strlen($expiresOn) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($expiresOn)), __LINE__);
        }
        $this->expiresOn = $expiresOn;
        return $this;
    }
    /**
     * Get adminEnabled value
     * @return string|null
     */
    public function getAdminEnabled()
    {
        return $this->adminEnabled;
    }
    /**
     * Set adminEnabled value
     * @param string $adminEnabled
     * @return \StructType\RImeLearnedRoutes
     */
    public function setAdminEnabled($adminEnabled = 'false')
    {
        // validation for constraint: string
        if (!is_null($adminEnabled) && !is_string($adminEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adminEnabled, true), gettype($adminEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($adminEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $adminEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($adminEnabled, true)), __LINE__);
        }
        $this->adminEnabled = $adminEnabled;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RImeLearnedRoutes
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
