<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDevicePool StructType
 * @subpackage Structs
 */
class RDevicePool extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Not nullable.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The autoSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $autoSearchSpaceName;
    /**
     * The dateTimeSettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $dateTimeSettingName;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $regionName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XCountry in AXLEnums.xsd
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The srstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $srstName;
    /**
     * The connectionMonitorDuration
     * Meta information extracted from the WSDL
     * - documentation: -1 means using system default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectionMonitorDuration;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Automated Alternate Routing. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - documentation: For IP Phones and Gateways. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mobilityCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Device Mobility. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mobilityCssName;
    /**
     * The physicalLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $physicalLocationName;
    /**
     * The deviceMobilityGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $deviceMobilityGroupName;
    /**
     * The revertPriority
     * Meta information extracted from the WSDL
     * - documentation: The value accepted and retrieved from the database for this field will be of type XRevertPriority in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $revertPriority;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The localRouteGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $localRouteGroupName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The callingPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The adjunctCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $adjunctCallingSearchSpace;
    /**
     * The callingPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The localRouteGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocalRouteGroup[]
     */
    public $localRouteGroup;
    /**
     * The redirectingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $redirectingPartyTransformationCSS;
    /**
     * The callingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyTransformationCSS;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDevicePool
     * @uses RDevicePool::setName()
     * @uses RDevicePool::setAutoSearchSpaceName()
     * @uses RDevicePool::setDateTimeSettingName()
     * @uses RDevicePool::setCallManagerGroupName()
     * @uses RDevicePool::setMediaResourceListName()
     * @uses RDevicePool::setRegionName()
     * @uses RDevicePool::setNetworkLocale()
     * @uses RDevicePool::setSrstName()
     * @uses RDevicePool::setConnectionMonitorDuration()
     * @uses RDevicePool::setAutomatedAlternateRoutingCssName()
     * @uses RDevicePool::setAarNeighborhoodName()
     * @uses RDevicePool::setLocationName()
     * @uses RDevicePool::setMobilityCssName()
     * @uses RDevicePool::setPhysicalLocationName()
     * @uses RDevicePool::setDeviceMobilityGroupName()
     * @uses RDevicePool::setRevertPriority()
     * @uses RDevicePool::setSingleButtonBarge()
     * @uses RDevicePool::setJoinAcrossLines()
     * @uses RDevicePool::setCgpnTransformationCssName()
     * @uses RDevicePool::setCdpnTransformationCssName()
     * @uses RDevicePool::setLocalRouteGroupName()
     * @uses RDevicePool::setGeoLocationName()
     * @uses RDevicePool::setGeoLocationFilterName()
     * @uses RDevicePool::setCallingPartyNationalPrefix()
     * @uses RDevicePool::setCallingPartyInternationalPrefix()
     * @uses RDevicePool::setCallingPartyUnknownPrefix()
     * @uses RDevicePool::setCallingPartySubscriberPrefix()
     * @uses RDevicePool::setAdjunctCallingSearchSpace()
     * @uses RDevicePool::setCallingPartyNationalStripDigits()
     * @uses RDevicePool::setCallingPartyInternationalStripDigits()
     * @uses RDevicePool::setCallingPartyUnknownStripDigits()
     * @uses RDevicePool::setCallingPartySubscriberStripDigits()
     * @uses RDevicePool::setCallingPartyNationalTransformationCssName()
     * @uses RDevicePool::setCallingPartyInternationalTransformationCssName()
     * @uses RDevicePool::setCallingPartyUnknownTransformationCssName()
     * @uses RDevicePool::setCallingPartySubscriberTransformationCssName()
     * @uses RDevicePool::setCalledPartyNationalPrefix()
     * @uses RDevicePool::setCalledPartyInternationalPrefix()
     * @uses RDevicePool::setCalledPartyUnknownPrefix()
     * @uses RDevicePool::setCalledPartySubscriberPrefix()
     * @uses RDevicePool::setCalledPartyNationalStripDigits()
     * @uses RDevicePool::setCalledPartyInternationalStripDigits()
     * @uses RDevicePool::setCalledPartyUnknownStripDigits()
     * @uses RDevicePool::setCalledPartySubscriberStripDigits()
     * @uses RDevicePool::setCalledPartyNationalTransformationCssName()
     * @uses RDevicePool::setCalledPartyInternationalTransformationCssName()
     * @uses RDevicePool::setCalledPartyUnknownTransformationCssName()
     * @uses RDevicePool::setCalledPartySubscriberTransformationCssName()
     * @uses RDevicePool::setImeEnrolledPatternGroupName()
     * @uses RDevicePool::setCntdPnTransformationCssName()
     * @uses RDevicePool::setLocalRouteGroup()
     * @uses RDevicePool::setRedirectingPartyTransformationCSS()
     * @uses RDevicePool::setCallingPartyTransformationCSS()
     * @uses RDevicePool::setWirelessLanProfileGroup()
     * @uses RDevicePool::setUuid()
     * @param string $name
     * @param \StructType\XFkType $autoSearchSpaceName
     * @param \StructType\XFkType $dateTimeSettingName
     * @param \StructType\XFkType $callManagerGroupName
     * @param \StructType\XFkType $mediaResourceListName
     * @param \StructType\XFkType $regionName
     * @param string $networkLocale
     * @param \StructType\XFkType $srstName
     * @param string $connectionMonitorDuration
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mobilityCssName
     * @param \StructType\XFkType $physicalLocationName
     * @param \StructType\XFkType $deviceMobilityGroupName
     * @param string $revertPriority
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param \StructType\XFkType $localRouteGroupName
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param \StructType\XFkType $adjunctCallingSearchSpace
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param \StructType\XFkType $imeEnrolledPatternGroupName
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @param \StructType\LocalRouteGroup[] $localRouteGroup
     * @param \StructType\XFkType $redirectingPartyTransformationCSS
     * @param \StructType\XFkType $callingPartyTransformationCSS
     * @param \StructType\XFkType $wirelessLanProfileGroup
     * @param string $uuid
     */
    public function __construct($name = null, \StructType\XFkType $autoSearchSpaceName = null, \StructType\XFkType $dateTimeSettingName = null, \StructType\XFkType $callManagerGroupName = null, \StructType\XFkType $mediaResourceListName = null, \StructType\XFkType $regionName = null, $networkLocale = null, \StructType\XFkType $srstName = null, $connectionMonitorDuration = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XFkType $locationName = null, \StructType\XFkType $mobilityCssName = null, \StructType\XFkType $physicalLocationName = null, \StructType\XFkType $deviceMobilityGroupName = null, $revertPriority = null, $singleButtonBarge = null, $joinAcrossLines = null, \StructType\XFkType $cgpnTransformationCssName = null, \StructType\XFkType $cdpnTransformationCssName = null, \StructType\XFkType $localRouteGroupName = null, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, \StructType\XFkType $adjunctCallingSearchSpace = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \StructType\XFkType $callingPartyNationalTransformationCssName = null, \StructType\XFkType $callingPartyInternationalTransformationCssName = null, \StructType\XFkType $callingPartyUnknownTransformationCssName = null, \StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \StructType\XFkType $calledPartyNationalTransformationCssName = null, \StructType\XFkType $calledPartyInternationalTransformationCssName = null, \StructType\XFkType $calledPartyUnknownTransformationCssName = null, \StructType\XFkType $calledPartySubscriberTransformationCssName = null, \StructType\XFkType $imeEnrolledPatternGroupName = null, \StructType\XFkType $cntdPnTransformationCssName = null, array $localRouteGroup = array(), \StructType\XFkType $redirectingPartyTransformationCSS = null, \StructType\XFkType $callingPartyTransformationCSS = null, \StructType\XFkType $wirelessLanProfileGroup = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setAutoSearchSpaceName($autoSearchSpaceName)
            ->setDateTimeSettingName($dateTimeSettingName)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setRegionName($regionName)
            ->setNetworkLocale($networkLocale)
            ->setSrstName($srstName)
            ->setConnectionMonitorDuration($connectionMonitorDuration)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLocationName($locationName)
            ->setMobilityCssName($mobilityCssName)
            ->setPhysicalLocationName($physicalLocationName)
            ->setDeviceMobilityGroupName($deviceMobilityGroupName)
            ->setRevertPriority($revertPriority)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setLocalRouteGroupName($localRouteGroupName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setAdjunctCallingSearchSpace($adjunctCallingSearchSpace)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setLocalRouteGroup($localRouteGroup)
            ->setRedirectingPartyTransformationCSS($redirectingPartyTransformationCSS)
            ->setCallingPartyTransformationCSS($callingPartyTransformationCSS)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RDevicePool
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get autoSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getAutoSearchSpaceName()
    {
        return $this->autoSearchSpaceName;
    }
    /**
     * Set autoSearchSpaceName value
     * @param \StructType\XFkType $autoSearchSpaceName
     * @return \StructType\RDevicePool
     */
    public function setAutoSearchSpaceName(\StructType\XFkType $autoSearchSpaceName = null)
    {
        $this->autoSearchSpaceName = $autoSearchSpaceName;
        return $this;
    }
    /**
     * Get dateTimeSettingName value
     * @return \StructType\XFkType|null
     */
    public function getDateTimeSettingName()
    {
        return $this->dateTimeSettingName;
    }
    /**
     * Set dateTimeSettingName value
     * @param \StructType\XFkType $dateTimeSettingName
     * @return \StructType\RDevicePool
     */
    public function setDateTimeSettingName(\StructType\XFkType $dateTimeSettingName = null)
    {
        $this->dateTimeSettingName = $dateTimeSettingName;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\RDevicePool
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\RDevicePool
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get regionName value
     * @return \StructType\XFkType|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \StructType\XFkType $regionName
     * @return \StructType\RDevicePool
     */
    public function setRegionName(\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\RDevicePool
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCountry', is_array($networkLocale) ? implode(', ', $networkLocale) : var_export($networkLocale, true), implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get srstName value
     * @return \StructType\XFkType|null
     */
    public function getSrstName()
    {
        return $this->srstName;
    }
    /**
     * Set srstName value
     * @param \StructType\XFkType $srstName
     * @return \StructType\RDevicePool
     */
    public function setSrstName(\StructType\XFkType $srstName = null)
    {
        $this->srstName = $srstName;
        return $this;
    }
    /**
     * Get connectionMonitorDuration value
     * @return string|null
     */
    public function getConnectionMonitorDuration()
    {
        return $this->connectionMonitorDuration;
    }
    /**
     * Set connectionMonitorDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionMonitorDuration
     * @return \StructType\RDevicePool
     */
    public function setConnectionMonitorDuration($connectionMonitorDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($connectionMonitorDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($connectionMonitorDuration) ? implode(', ', $connectionMonitorDuration) : var_export($connectionMonitorDuration, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->connectionMonitorDuration = $connectionMonitorDuration;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\RDevicePool
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\RDevicePool
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\RDevicePool
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mobilityCssName value
     * @return \StructType\XFkType|null
     */
    public function getMobilityCssName()
    {
        return $this->mobilityCssName;
    }
    /**
     * Set mobilityCssName value
     * @param \StructType\XFkType $mobilityCssName
     * @return \StructType\RDevicePool
     */
    public function setMobilityCssName(\StructType\XFkType $mobilityCssName = null)
    {
        $this->mobilityCssName = $mobilityCssName;
        return $this;
    }
    /**
     * Get physicalLocationName value
     * @return \StructType\XFkType|null
     */
    public function getPhysicalLocationName()
    {
        return $this->physicalLocationName;
    }
    /**
     * Set physicalLocationName value
     * @param \StructType\XFkType $physicalLocationName
     * @return \StructType\RDevicePool
     */
    public function setPhysicalLocationName(\StructType\XFkType $physicalLocationName = null)
    {
        $this->physicalLocationName = $physicalLocationName;
        return $this;
    }
    /**
     * Get deviceMobilityGroupName value
     * @return \StructType\XFkType|null
     */
    public function getDeviceMobilityGroupName()
    {
        return $this->deviceMobilityGroupName;
    }
    /**
     * Set deviceMobilityGroupName value
     * @param \StructType\XFkType $deviceMobilityGroupName
     * @return \StructType\RDevicePool
     */
    public function setDeviceMobilityGroupName(\StructType\XFkType $deviceMobilityGroupName = null)
    {
        $this->deviceMobilityGroupName = $deviceMobilityGroupName;
        return $this;
    }
    /**
     * Get revertPriority value
     * @return string|null
     */
    public function getRevertPriority()
    {
        return $this->revertPriority;
    }
    /**
     * Set revertPriority value
     * @uses \EnumType\XRevertPriority::valueIsValid()
     * @uses \EnumType\XRevertPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revertPriority
     * @return \StructType\RDevicePool
     */
    public function setRevertPriority($revertPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRevertPriority::valueIsValid($revertPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRevertPriority', is_array($revertPriority) ? implode(', ', $revertPriority) : var_export($revertPriority, true), implode(', ', \EnumType\XRevertPriority::getValidValues())), __LINE__);
        }
        $this->revertPriority = $revertPriority;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \EnumType\XBarge::valueIsValid()
     * @uses \EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \StructType\RDevicePool
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XBarge', is_array($singleButtonBarge) ? implode(', ', $singleButtonBarge) : var_export($singleButtonBarge, true), implode(', ', \EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \StructType\RDevicePool
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($joinAcrossLines) ? implode(', ', $joinAcrossLines) : var_export($joinAcrossLines, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get localRouteGroupName value
     * @return \StructType\XFkType|null
     */
    public function getLocalRouteGroupName()
    {
        return $this->localRouteGroupName;
    }
    /**
     * Set localRouteGroupName value
     * @param \StructType\XFkType $localRouteGroupName
     * @return \StructType\RDevicePool
     */
    public function setLocalRouteGroupName(\StructType\XFkType $localRouteGroupName = null)
    {
        $this->localRouteGroupName = $localRouteGroupName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\RDevicePool
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\RDevicePool
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyNationalPrefix) && !is_string($callingPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyNationalPrefix, true), gettype($callingPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartyNationalPrefix) && mb_strlen($callingPartyNationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartyNationalPrefix)), __LINE__);
        }
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyInternationalPrefix) && !is_string($callingPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyInternationalPrefix, true), gettype($callingPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartyInternationalPrefix) && mb_strlen($callingPartyInternationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartyInternationalPrefix)), __LINE__);
        }
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyUnknownPrefix) && !is_string($callingPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyUnknownPrefix, true), gettype($callingPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartyUnknownPrefix) && mb_strlen($callingPartyUnknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartyUnknownPrefix)), __LINE__);
        }
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \StructType\RDevicePool
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartySubscriberPrefix) && !is_string($callingPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartySubscriberPrefix, true), gettype($callingPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($callingPartySubscriberPrefix) && mb_strlen($callingPartySubscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($callingPartySubscriberPrefix)), __LINE__);
        }
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get adjunctCallingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getAdjunctCallingSearchSpace()
    {
        return $this->adjunctCallingSearchSpace;
    }
    /**
     * Set adjunctCallingSearchSpace value
     * @param \StructType\XFkType $adjunctCallingSearchSpace
     * @return \StructType\RDevicePool
     */
    public function setAdjunctCallingSearchSpace(\StructType\XFkType $adjunctCallingSearchSpace = null)
    {
        $this->adjunctCallingSearchSpace = $adjunctCallingSearchSpace;
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return $this->callingPartyNationalStripDigits;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNationalStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyNationalStripDigits) ? implode(', ', $callingPartyNationalStripDigits) : var_export($callingPartyNationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return $this->callingPartyInternationalStripDigits;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyInternationalStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyInternationalStripDigits) ? implode(', ', $callingPartyInternationalStripDigits) : var_export($callingPartyInternationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return $this->callingPartyUnknownStripDigits;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyUnknownStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyUnknownStripDigits) ? implode(', ', $callingPartyUnknownStripDigits) : var_export($callingPartyUnknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return $this->callingPartySubscriberStripDigits;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySubscriberStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartySubscriberStripDigits) ? implode(', ', $callingPartySubscriberStripDigits) : var_export($callingPartySubscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return $this->callingPartyNationalTransformationCssName;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyNationalTransformationCssName(\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return $this->callingPartyInternationalTransformationCssName;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyInternationalTransformationCssName(\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return $this->callingPartyUnknownTransformationCssName;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyUnknownTransformationCssName(\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return $this->callingPartySubscriberTransformationCssName;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCallingPartySubscriberTransformationCssName(\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyNationalPrefix) && !is_string($calledPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyNationalPrefix, true), gettype($calledPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyNationalPrefix) && mb_strlen($calledPartyNationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyNationalPrefix)), __LINE__);
        }
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyInternationalPrefix) && !is_string($calledPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyInternationalPrefix, true), gettype($calledPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyInternationalPrefix) && mb_strlen($calledPartyInternationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyInternationalPrefix)), __LINE__);
        }
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyUnknownPrefix, true), gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyUnknownPrefix) && mb_strlen($calledPartyUnknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \StructType\RDevicePool
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartySubscriberPrefix) && !is_string($calledPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartySubscriberPrefix, true), gettype($calledPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartySubscriberPrefix) && mb_strlen($calledPartySubscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartySubscriberPrefix)), __LINE__);
        }
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return $this->calledPartyNationalStripDigits;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNationalStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyNationalStripDigits) ? implode(', ', $calledPartyNationalStripDigits) : var_export($calledPartyNationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return $this->calledPartyInternationalStripDigits;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyInternationalStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyInternationalStripDigits) ? implode(', ', $calledPartyInternationalStripDigits) : var_export($calledPartyInternationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return $this->calledPartyUnknownStripDigits;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyUnknownStripDigits) ? implode(', ', $calledPartyUnknownStripDigits) : var_export($calledPartyUnknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return $this->calledPartySubscriberStripDigits;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartySubscriberStripDigits
     * @return \StructType\RDevicePool
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartySubscriberStripDigits) ? implode(', ', $calledPartySubscriberStripDigits) : var_export($calledPartySubscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return $this->calledPartyNationalTransformationCssName;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyNationalTransformationCssName(\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return $this->calledPartyInternationalTransformationCssName;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyInternationalTransformationCssName(\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return $this->calledPartyUnknownTransformationCssName;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCalledPartyUnknownTransformationCssName(\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return $this->calledPartySubscriberTransformationCssName;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCalledPartySubscriberTransformationCssName(\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * @return \StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return $this->imeEnrolledPatternGroupName;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * @param \StructType\XFkType $imeEnrolledPatternGroupName
     * @return \StructType\RDevicePool
     */
    public function setImeEnrolledPatternGroupName(\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return $this->cntdPnTransformationCssName;
    }
    /**
     * Set cntdPnTransformationCssName value
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @return \StructType\RDevicePool
     */
    public function setCntdPnTransformationCssName(\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        return $this;
    }
    /**
     * Get localRouteGroup value
     * @return \StructType\LocalRouteGroup[]|null
     */
    public function getLocalRouteGroup()
    {
        return $this->localRouteGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalRouteGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalRouteGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalRouteGroupForArrayConstraintsFromSetLocalRouteGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rDevicePoolLocalRouteGroupItem) {
            // validation for constraint: itemType
            if (!$rDevicePoolLocalRouteGroupItem instanceof \StructType\LocalRouteGroup) {
                $invalidValues[] = is_object($rDevicePoolLocalRouteGroupItem) ? get_class($rDevicePoolLocalRouteGroupItem) : sprintf('%s(%s)', gettype($rDevicePoolLocalRouteGroupItem), var_export($rDevicePoolLocalRouteGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The localRouteGroup property can only contain items of type \StructType\LocalRouteGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set localRouteGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\LocalRouteGroup[] $localRouteGroup
     * @return \StructType\RDevicePool
     */
    public function setLocalRouteGroup(array $localRouteGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($localRouteGroupArrayErrorMessage = self::validateLocalRouteGroupForArrayConstraintsFromSetLocalRouteGroup($localRouteGroup))) {
            throw new \InvalidArgumentException($localRouteGroupArrayErrorMessage, __LINE__);
        }
        $this->localRouteGroup = $localRouteGroup;
        return $this;
    }
    /**
     * Add item to localRouteGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\LocalRouteGroup $item
     * @return \StructType\RDevicePool
     */
    public function addToLocalRouteGroup(\StructType\LocalRouteGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocalRouteGroup) {
            throw new \InvalidArgumentException(sprintf('The localRouteGroup property can only contain items of type \StructType\LocalRouteGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->localRouteGroup[] = $item;
        return $this;
    }
    /**
     * Get redirectingPartyTransformationCSS value
     * @return \StructType\XFkType|null
     */
    public function getRedirectingPartyTransformationCSS()
    {
        return $this->redirectingPartyTransformationCSS;
    }
    /**
     * Set redirectingPartyTransformationCSS value
     * @param \StructType\XFkType $redirectingPartyTransformationCSS
     * @return \StructType\RDevicePool
     */
    public function setRedirectingPartyTransformationCSS(\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        $this->redirectingPartyTransformationCSS = $redirectingPartyTransformationCSS;
        return $this;
    }
    /**
     * Get callingPartyTransformationCSS value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSS()
    {
        return $this->callingPartyTransformationCSS;
    }
    /**
     * Set callingPartyTransformationCSS value
     * @param \StructType\XFkType $callingPartyTransformationCSS
     * @return \StructType\RDevicePool
     */
    public function setCallingPartyTransformationCSS(\StructType\XFkType $callingPartyTransformationCSS = null)
    {
        $this->callingPartyTransformationCSS = $callingPartyTransformationCSS;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return \StructType\XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param \StructType\XFkType $wirelessLanProfileGroup
     * @return \StructType\RDevicePool
     */
    public function setWirelessLanProfileGroup(\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RDevicePool
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
