<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallerFilterList StructType
 * @subpackage Structs
 */
class RCallerFilterList extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isAllowedType
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAllowedType;
    /**
     * The endUserIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $endUserIdName;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallerFilterList
     * @uses RCallerFilterList::setName()
     * @uses RCallerFilterList::setDescription()
     * @uses RCallerFilterList::setIsAllowedType()
     * @uses RCallerFilterList::setEndUserIdName()
     * @uses RCallerFilterList::setMembers()
     * @uses RCallerFilterList::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isAllowedType
     * @param \StructType\XFkType $endUserIdName
     * @param \StructType\Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isAllowedType = null, \StructType\XFkType $endUserIdName = null, \StructType\Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsAllowedType($isAllowedType)
            ->setEndUserIdName($endUserIdName)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RCallerFilterList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RCallerFilterList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isAllowedType value
     * @return string|null
     */
    public function getIsAllowedType()
    {
        return $this->isAllowedType;
    }
    /**
     * Set isAllowedType value
     * @param string $isAllowedType
     * @return \StructType\RCallerFilterList
     */
    public function setIsAllowedType($isAllowedType = null)
    {
        // validation for constraint: string
        if (!is_null($isAllowedType) && !is_string($isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isAllowedType, true), gettype($isAllowedType)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isAllowedType) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isAllowedType, true)), __LINE__);
        }
        $this->isAllowedType = $isAllowedType;
        return $this;
    }
    /**
     * Get endUserIdName value
     * @return \StructType\XFkType|null
     */
    public function getEndUserIdName()
    {
        return $this->endUserIdName;
    }
    /**
     * Set endUserIdName value
     * @param \StructType\XFkType $endUserIdName
     * @return \StructType\RCallerFilterList
     */
    public function setEndUserIdName(\StructType\XFkType $endUserIdName = null)
    {
        $this->endUserIdName = $endUserIdName;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\RCallerFilterList
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RCallerFilterList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
