<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallForwardAlternateParty StructType
 * @subpackage Structs
 */
class RCallForwardAlternateParty extends AbstractStructBase
{
    /**
     * The forwardToVoiceMail
     * Meta information extracted from the WSDL
     * - documentation: DB: Derived from CF*VoiceMailEnabled fields. This tag has been marked as ReadOnly for callForwardAlternateParty as it is not applicable for callForwardAlternateParty setting.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for callForwardNoAnswer and callForwardAlternateParty,Value "-1" in the response indicates that the CM will use the default setting
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $duration;
    /**
     * Constructor method for RCallForwardAlternateParty
     * @uses RCallForwardAlternateParty::setForwardToVoiceMail()
     * @uses RCallForwardAlternateParty::setCallingSearchSpaceName()
     * @uses RCallForwardAlternateParty::setDestination()
     * @uses RCallForwardAlternateParty::setDuration()
     * @param string $forwardToVoiceMail
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param string $destination
     * @param string $duration
     */
    public function __construct($forwardToVoiceMail = null, \StructType\XFkType $callingSearchSpaceName = null, $destination = null, $duration = null)
    {
        $this
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination)
            ->setDuration($duration);
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return \StructType\RCallForwardAlternateParty
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardToVoiceMail, true), gettype($forwardToVoiceMail)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\RCallForwardAlternateParty
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\RCallForwardAlternateParty
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($destination) && mb_strlen($destination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duration
     * @return \StructType\RCallForwardAlternateParty
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($duration) ? implode(', ', $duration) : var_export($duration, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
}
