<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAudioCodecPreferenceList StructType
 * @subpackage Structs
 */
class RAudioCodecPreferenceList extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The codecsInList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodecsInList
     */
    public $codecsInList;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAudioCodecPreferenceList
     * @uses RAudioCodecPreferenceList::setName()
     * @uses RAudioCodecPreferenceList::setDescription()
     * @uses RAudioCodecPreferenceList::setCodecsInList()
     * @uses RAudioCodecPreferenceList::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\CodecsInList $codecsInList
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\CodecsInList $codecsInList = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setCodecsInList($codecsInList)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RAudioCodecPreferenceList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RAudioCodecPreferenceList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get codecsInList value
     * @return \StructType\CodecsInList|null
     */
    public function getCodecsInList()
    {
        return $this->codecsInList;
    }
    /**
     * Set codecsInList value
     * @param \StructType\CodecsInList $codecsInList
     * @return \StructType\RAudioCodecPreferenceList
     */
    public function setCodecsInList(\StructType\CodecsInList $codecsInList = null)
    {
        $this->codecsInList = $codecsInList;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RAudioCodecPreferenceList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
